"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowUnsavedChangesBadge = WorkflowUnsavedChangesBadge;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _use_formatted_date = require("../../../shared/ui/use_formatted_date");
var _ui = require("../../../shared/ui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/widgets/workflow_yaml_editor/ui/workflow_unsaved_changes_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function WorkflowUnsavedChangesBadge({
  hasChanges,
  highlightDiff,
  setHighlightDiff,
  lastUpdatedAt
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const getFormattedDateTime = (0, _use_formatted_date.useGetFormattedDateTime)();
  const fullDateFormatted = lastUpdatedAt ? getFormattedDateTime(lastUpdatedAt) : undefined;
  const label = highlightDiff ? _i18n.i18n.translate('workflows.unsavedChangesBadge.hideDiff', {
    defaultMessage: 'Hide diff highlighting'
  }) : _i18n.i18n.translate('workflows.unsavedChangesBadge.showDiff', {
    defaultMessage: 'Show diff highlighting'
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, hasChanges ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": "workflowUnsavedChangesBadge",
    color: euiTheme.colors.backgroundLightWarning,
    onClick: () => setHighlightDiff(state => !state),
    role: "button",
    tabIndex: 0,
    "aria-pressed": highlightDiff,
    onClickAriaLabel: label,
    onKeyDown: () => {},
    title: label,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "workflows.unsavedChangesBadge",
    defaultMessage: "Unsaved changes",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: "check",
    color: euiTheme.colors.backgroundBaseDisabled,
    "aria-label": fullDateFormatted,
    title: fullDateFormatted,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "workflows.workflowDetail.yamlEditor.saved",
    defaultMessage: "Saved",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }), ' ', lastUpdatedAt ? /*#__PURE__*/_react.default.createElement(_ui.FormattedRelativeEnhanced, {
    value: lastUpdatedAt,
    style: "short",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 28
    }
  }) : null));
}