"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.insertTriggerSnippet = insertTriggerSnippet;
var _monaco = require("@kbn/monaco");
var _yaml_utils = require("../../../../../common/lib/yaml_utils");
var _utils = require("../utils");
var _get_indent_level = require("../get_indent_level");
var _prepend_indent_to_lines = require("../prepend_indent_to_lines");
var _generate_trigger_snippet = require("./generate_trigger_snippet");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Algorithm:
// 1. Find the next line after the last trigger node range
// 2. If no trigger nodes found, add triggers: section in the first line of yaml

function insertTriggerSnippet(model, yamlDocument, triggerType, editor) {
  // find triggers: line number and column number
  const triggerNodes = (0, _yaml_utils.getTriggerNodes)(yamlDocument);
  const triggerNode = triggerNodes.find(node => node.triggerType === triggerType);
  let insertTriggersSection = false;
  let insertAtLineNumber = 1;
  let indentLevel = 0;
  if (triggerNode) {
    // do not override existing trigger
    return;
  }
  if (triggerNodes.length > 0) {
    const lastTriggerRange = (0, _utils.getMonacoRangeFromYamlNode)(model, triggerNodes[triggerNodes.length - 1].node);
    if (lastTriggerRange) {
      // add a newline after the last trigger
      insertAtLineNumber = lastTriggerRange.endLineNumber;
      indentLevel = (0, _get_indent_level.getIndentLevelFromLineNumber)(model, lastTriggerRange.startLineNumber);
    }
  } else {
    insertTriggersSection = true;
  }
  const triggerSnippet = (0, _generate_trigger_snippet.generateTriggerSnippet)(triggerType, {
    full: true,
    monacoSuggestionFormat: false,
    withTriggersSection: insertTriggersSection
  });

  // Create separate undo boundary for each snippet insertion
  if (editor) {
    editor.pushUndoStop();
  }
  model.pushEditOperations(null, [{
    range: new _monaco.monaco.Range(insertAtLineNumber, 1, insertAtLineNumber, 1),
    text: insertTriggersSection ? triggerSnippet : (0, _prepend_indent_to_lines.prependIndentToLines)(triggerSnippet, indentLevel)
  }], () => null);
  if (editor) {
    editor.pushUndoStop();
  }
}