"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndentLevel = getIndentLevel;
exports.getIndentLevelFromLineNumber = getIndentLevelFromLineNumber;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Get the indentation level (number of spaces) for a line
 */
function getIndentLevel(line) {
  const match = line.match(/^(\s*)/);
  return match ? match[1].length : 0;
}
function getIndentLevelFromLineNumber(model, lineNumber) {
  const line = model.getLineContent(lineNumber);
  return getIndentLevel(line);
}