"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowsFilterPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/widgets/workflow_filter_popover/workflow_filter_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WORKFLOW_POPOVER_WIDTH = 500;
const WorkflowsFilterPopoverComponent = ({
  filter,
  title,
  values,
  selectedValues,
  onSelectedValuesChanged
}) => {
  const [isFilterPopoverOpen, setIsFilterPopoverOpen] = (0, _react.useState)(false);
  const [selectableOptions, setSelectableOptions] = (0, _react.useState)(() => {
    const selectedValuesSet = new Set(selectedValues);
    return values.map(({
      label,
      key
    }) => ({
      label,
      key,
      checked: selectedValuesSet.has(key) ? 'on' : undefined
    }));
  });
  const handleSelectableOptionsChange = newOptions => {
    onSelectedValuesChanged(newOptions.map(({
      key,
      checked
    }) => checked ? key : null).filter(value => value !== null));
  };
  (0, _react.useEffect)(() => {
    const selectedValuesSet = new Set(selectedValues);
    const newSelectableOptions = values.map(({
      label,
      key
    }) => {
      return {
        label: label !== null && label !== void 0 ? label : key,
        key,
        checked: selectedValuesSet.has(key) ? 'on' : undefined
      };
    });
    setSelectableOptions(newSelectableOptions);
  }, [values, selectedValues]);
  const triggerButton = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    grow: true,
    iconType: "arrowDown",
    onClick: () => setIsFilterPopoverOpen(!isFilterPopoverOpen),
    numFilters: values.length,
    isSelected: isFilterPopoverOpen,
    hasActiveFilters: selectedValues.length > 0,
    numActiveFilters: selectedValues.length,
    "data-test-subj": `${filter}-filter-popover-button`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, title);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: triggerButton,
    isOpen: isFilterPopoverOpen,
    closePopover: () => setIsFilterPopoverOpen(!isFilterPopoverOpen),
    panelPaddingSize: "none",
    repositionOnScroll: true,
    panelProps: {
      'data-test-subj': `${filter}-filter-popover`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    searchProps: {
      placeholder: 'Search'
    },
    "aria-label": "Search",
    options: selectableOptions,
    onChange: handleSelectableOptionsChange,
    emptyMessage: "No items available",
    noMatchesMessage: "No items available",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
    css: {
      width: WORKFLOW_POPOVER_WIDTH
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  }, search), list)));
};
WorkflowsFilterPopoverComponent.displayName = 'WorkflowsFilterPopoverComponent';
const WorkflowsFilterPopover = exports.WorkflowsFilterPopover = /*#__PURE__*/_react.default.memo(WorkflowsFilterPopoverComponent);
WorkflowsFilterPopover.displayName = 'WorkflowsFilterPopover';