"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PopoverItems = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/widgets/worflows_triggers_list/popover_items/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PopoverItemsWrapper = props => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, (0, _extends2.default)({}, props, {
  css: (0, _react2.css)`
      width: 100%;
    `,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 38,
    columnNumber: 3
  }
}));
const PopoverWrapper = props => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, (0, _extends2.default)({}, props, {
    css: (0, _react2.css)`
        max-height: 200px;
        max-width: 600px;
        overflow: auto;
        line-height: ${euiTheme.size.l};
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }));
};

/**
 * Component to render list of items in popover, wicth configurabe number of display items by default
 * @param items - array of items to render
 * @param renderItem - render function that render item, arguments: item, index, items[]
 * @param popoverTitle - title of popover
 * @param popoverButtonTitle - title of popover button that triggers popover
 * @param popoverButtonIcon - icon of popover button that triggers popover
 * @param numberOfItemsToDisplay - number of items to render that are no in popover, defaults to 0
 * @param dataTestPrefix - data-test-subj prefix to apply to elements
 */
const PopoverItemsComponent = ({
  items,
  renderItem,
  popoverTitle,
  popoverButtonTitle,
  popoverButtonIcon,
  numberOfItemsToDisplay = 0,
  dataTestPrefix = 'items'
}) => {
  const [isExceptionOverflowPopoverOpen, setIsExceptionOverflowPopoverOpen] = (0, _react.useState)(false);
  const OverflowList = ({
    items: itemsToRender
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, itemsToRender.map(renderItem));
  if (items.length <= numberOfItemsToDisplay) {
    return /*#__PURE__*/_react.default.createElement(PopoverItemsWrapper, {
      "data-test-subj": dataTestPrefix,
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(OverflowList, {
      items: items,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(PopoverItemsWrapper, {
    alignItems: "center",
    gutterSize: "s",
    "data-test-subj": dataTestPrefix,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, numberOfItemsToDisplay !== 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    className: "eui-textTruncate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(OverflowList, {
    items: items.slice(0, numberOfItemsToDisplay),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    "data-test-subj": `${dataTestPrefix}DisplayPopover`,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      iconType: popoverButtonIcon,
      color: "hollow",
      "data-test-subj": `${dataTestPrefix}DisplayPopoverButton`,
      onClick: () => setIsExceptionOverflowPopoverOpen(!isExceptionOverflowPopoverOpen),
      onClickAriaLabel: popoverButtonTitle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 11
      }
    }, popoverButtonTitle),
    isOpen: isExceptionOverflowPopoverOpen,
    closePopover: () => setIsExceptionOverflowPopoverOpen(!isExceptionOverflowPopoverOpen),
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }, popoverTitle ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    "data-test-subj": `${dataTestPrefix}DisplayPopoverTitle`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }, popoverTitle) : null, /*#__PURE__*/_react.default.createElement(PopoverWrapper, {
    "data-test-subj": `${dataTestPrefix}DisplayPopoverWrapper`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(OverflowList, {
    items: items.slice(numberOfItemsToDisplay),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }))));
};
const MemoizedPopoverItems = /*#__PURE__*/_react.default.memo(PopoverItemsComponent);
MemoizedPopoverItems.displayName = 'PopoverItems';
const PopoverItems = exports.PopoverItems = MemoizedPopoverItems;