"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRunWorkflowTooltipContent = getRunWorkflowTooltipContent;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getRunWorkflowTooltipContent(isValid, canRunWorkflow, isEnabled, isTest) {
  if (!isValid) {
    return _i18n.i18n.translate('workflows.actionButtons.runWorkflow.invalid', {
      defaultMessage: 'Fix errors to run workflow'
    });
  }
  if (!canRunWorkflow) {
    return _i18n.i18n.translate('workflows.actionButtons.runWorkflow.notAllowed', {
      defaultMessage: 'You are not allowed to run workflows'
    });
  }
  if (!isEnabled && !isTest) {
    return _i18n.i18n.translate('workflows.actionButtons.runWorkflow.disabled', {
      defaultMessage: 'Enable the workflow to run it'
    });
  }
  return null;
}