"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepIcon = StepIcon;
var _eui = require("@elastic/eui");
var _workflows = require("@kbn/workflows");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _get_step_icon_type = require("./get_step_icon_type");
var _status_badge = require("./status_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/shared/ui/step_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function StepIcon({
  stepType,
  executionStatus
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (executionStatus === _workflows.ExecutionStatus.RUNNING) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 12
      }
    });
  }
  if (executionStatus === _workflows.ExecutionStatus.WAITING_FOR_INPUT) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBeacon, {
      size: 14,
      color: "warning",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 12
      }
    });
  }
  const iconType = (0, _get_step_icon_type.getStepIconType)(stepType);
  if (iconType.startsWith('token')) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
      iconType: iconType,
      size: "s",
      color: (0, _status_badge.getExecutionStatusColors)(euiTheme, executionStatus).tokenColor,
      fill: "light",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: iconType,
    size: "m",
    color: (0, _status_badge.getExecutionStatusColors)(euiTheme, executionStatus).color,
    css:
    // change fill and color of the icon for non-completed statuses, for multi-color logos
    executionStatus !== _workflows.ExecutionStatus.COMPLETED && (0, _react2.css)`
          & * {
            fill: ${(0, _status_badge.getExecutionStatusColors)(euiTheme, executionStatus).color};
            color: ${(0, _status_badge.getExecutionStatusColors)(euiTheme, executionStatus).color};
          }
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  });
}