"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormattedRelativeEnhanced = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _intlUtils = require("@formatjs/intl-utils");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require("..");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/shared/ui/formatted_relative_enhanced/formatted_relative_enhanced.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Mimic `FormattedRelative` previous behavior from formatJS v2
 */
const FormattedRelativeEnhanced = ({
  value: valueInput,
  updateIntervalInSeconds,
  thresholds,
  numeric = 'auto',
  fullDateTooltip = false,
  fullDateTooltipPosition,
  ...rest
}) => {
  const valueDate = (0, _moment.default)(valueInput).isValid() ? (0, _moment.default)(valueInput).toDate() : new Date();
  const fullDateFormatted = (0, _.useFormattedDateTime)(valueDate);
  const {
    value,
    unit
  } = (0, _intlUtils.selectUnit)(valueDate, new Date(), thresholds);
  if (unit === 'second') {
    return _i18n.i18n.translate('workflows.formattedRelativeEnhanced.justNow', {
      defaultMessage: 'just now'
    });
  }
  const content = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelativeTime, (0, _extends2.default)({
    value: value,
    unit: unit,
    updateIntervalInSeconds: updateIntervalInSeconds
  }, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }));
  if (!fullDateTooltip) {
    return content;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: fullDateFormatted,
    position: fullDateTooltipPosition,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, content);
};
exports.FormattedRelativeEnhanced = FormattedRelativeEnhanced;