"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.kibanaFlatten = kibanaFlatten;
var _lodash = _interopRequireDefault(require("lodash"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Takes an object and returns a flattened version, including nested arrays in a kibana way similar to the flattenHit function.
 *
 * @param {Record<string, unknown>} obj - object to flatten
 * @param {boolean} deep - whether to look into objects within arrays
 * @returns {Record<string, unknown | unknown[]>}
 */
function kibanaFlatten(obj, deep = true) {
  const flat = {};

  // recursively merge object
  (function flatten(_obj, keyPrefix = '') {
    keyPrefix = keyPrefix ? keyPrefix + '.' : '';
    _lodash.default.forOwn(_obj, function (val, key) {
      key = keyPrefix + key;
      if (deep) {
        const isArrayOfObjects = Array.isArray(val) && _lodash.default.isPlainObject(_lodash.default.first(val));
        if (isArrayOfObjects) {
          _lodash.default.each(val, v => flatten(v, key));
          return;
        }
      } else if (flat[key] !== void 0) {
        return;
      }
      const isValue = !_lodash.default.isPlainObject(val);
      if (isValue) {
        if (!flat[key]) {
          flat[key] = val;
        } else if (Array.isArray(flat[key])) {
          flat[key].push(val);
        } else {
          flat[key] = [flat[key], val];
        }
        return;
      }
      flatten(val, key);
    });
  })(obj);
  return flat;
}