"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowsPage = WorkflowsPage;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("@kbn/workflows/common/constants");
var _react = _interopRequireWildcard(require("react"));
var _use_workflow_actions = require("../../entities/workflows/model/use_workflow_actions");
var _use_workflow_stats = require("../../entities/workflows/model/use_workflow_stats");
var _use_workflows = require("../../entities/workflows/model/use_workflows");
var _ui = require("../../features/workflow_executions_stats/ui");
var _workflow_list = require("../../features/workflow_list");
var _constants2 = require("../../features/workflow_list/constants");
var _use_workflow_breadcrumbs = require("../../hooks/use_workflow_breadcrumbs/use_workflow_breadcrumbs");
var _workflow_utils = require("../../shared/utils/workflow_utils");
var _workflow_filter_popover = require("../../widgets/workflow_filter_popover/workflow_filter_popover");
var _workflow_search_field = require("../../widgets/workflow_search_field/ui/workflow_search_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/pages/workflows/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const workflowTemplateYaml = `name: New workflow
enabled: false
triggers:
  - type: manual
steps:
  - name: first-step
    type: console
    with:
      message: First step executed
`;
function WorkflowsPage() {
  const {
    application,
    notifications,
    featureFlags
  } = (0, _public.useKibana)().services;
  const {
    data: filtersData
  } = (0, _use_workflow_stats.useWorkflowFiltersOptions)(['enabled', 'createdBy']);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    createWorkflow
  } = (0, _use_workflow_actions.useWorkflowActions)();
  const [search, setSearch] = (0, _react.useState)({
    limit: _constants2.WORKFLOWS_TABLE_INITIAL_PAGE_SIZE,
    page: 1,
    query: ''
  });
  const {
    data: workflows,
    refetch
  } = (0, _use_workflows.useWorkflows)(search);
  (0, _use_workflow_breadcrumbs.useWorkflowsBreadcrumbs)();
  const canCreateWorkflow = application === null || application === void 0 ? void 0 : application.capabilities.workflowsManagement.createWorkflow;
  const isExecutionStatsBarEnabled = featureFlags === null || featureFlags === void 0 ? void 0 : featureFlags.getBooleanValue(_constants.WORKFLOW_EXECUTION_STATS_BAR_SETTING_ID, false);

  // Check if we should show empty state
  const shouldShowEmptyState = (0, _workflow_utils.shouldShowWorkflowsEmptyState)(workflows, search);
  const handleCreateWorkflow = () => {
    createWorkflow.mutate({
      yaml: workflowTemplateYaml
    }, {
      onSuccess: data => {
        application.navigateToUrl(application.getUrlForApp('workflows', {
          path: `/${data.id}`
        }));
        refetch();
      },
      onError: error => {
        // Extract message from HTTP error body and update the error message
        if (error && typeof error === 'object' && 'body' in error && error.body && typeof error.body === 'object' && 'message' in error.body && typeof error.body.message === 'string') {
          error.message = error.body.message;
        }
        notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('workflows.createWorkflowError', {
            defaultMessage: 'Error creating workflow'
          })
        });
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
    offset: 0,
    css: {
      backgroundColor: euiTheme.colors.backgroundBasePlain
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Header, {
    bottomBorder: false,
    css: {
      marginBottom: `-${euiTheme.size.l}`
    },
    restrictWidth: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: 'spaceBetween',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "flexStart",
      gutterSize: "s",
      responsive: false,
      wrap: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "workflows.pageTitle",
      defaultMessage: "Workflows",
      ignoreTag: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "workflows.technicalPreviewBadge",
        defaultMessage: "Technical Preview",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 25
        }
      }),
      title: "Technical Preview",
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 21
      }
    }))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 13
    }
  }, canCreateWorkflow && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "plusInCircle",
    color: "primary",
    size: "m",
    fill: true,
    onClick: handleCreateWorkflow,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "workflows.createWorkflowButton",
    defaultMessage: "Create a new workflow",
    ignoreTag: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 19
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    restrictWidth: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 7
    }
  }, !shouldShowEmptyState && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_workflow_search_field.WorkflowSearchField, {
    initialValue: search.query || '',
    onSearch: query => setSearch(prevState => {
      return {
        ...prevState,
        query
      };
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_workflow_filter_popover.WorkflowsFilterPopover, {
    filter: "enabled",
    title: "Enabled",
    values: (filtersData === null || filtersData === void 0 ? void 0 : filtersData.enabled) || [],
    selectedValues: search.enabled || [],
    onSelectedValuesChanged: newValues => {
      setSearch(prevState => {
        return {
          ...prevState,
          enabled: newValues
        };
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_workflow_filter_popover.WorkflowsFilterPopover, {
    filter: "createdBy",
    title: "Created By",
    values: (filtersData === null || filtersData === void 0 ? void 0 : filtersData.createdBy) || [],
    selectedValues: search.createdBy || [],
    onSelectedValuesChanged: newValues => {
      setSearch(prevState => {
        return {
          ...prevState,
          createdBy: newValues
        };
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 19
    }
  })))), isExecutionStatsBarEnabled && /*#__PURE__*/_react.default.createElement(_ui.WorkflowExecutionStatsBar, {
    height: 140,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 44
    }
  })), /*#__PURE__*/_react.default.createElement(_workflow_list.WorkflowList, {
    search: search,
    setSearch: setSearch,
    onCreateWorkflow: handleCreateWorkflow,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 9
    }
  })));
}