"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowDetailHeader = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = _interopRequireWildcard(require("react"));
var _workflow_unsaved_changes_badge = require("../../../widgets/workflow_yaml_editor/ui/workflow_unsaved_changes_badge");
var _ui = require("../../../shared/ui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/pages/workflow_detail/ui/workflow_detail_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WorkflowDetailHeader = ({
  name,
  isLoading,
  activeTab,
  canRunWorkflow,
  handleRunClick,
  handleSave,
  canSaveWorkflow,
  isEnabled,
  handleToggleWorkflow,
  canTestWorkflow,
  handleTestClick,
  handleTabChange,
  isValid,
  hasUnsavedChanges,
  highlightDiff,
  setHighlightDiff,
  lastUpdatedAt
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const [showRunConfirmation, setShowRunConfirmation] = (0, _react2.useState)(false);
  const buttonGroupOptions = (0, _react2.useMemo)(() => [{
    id: 'workflow',
    label: 'Workflow',
    iconType: 'grid',
    type: 'button'
  }, {
    id: 'executions',
    label: 'Executions',
    iconType: 'play'
  }], []);
  const runWorkflowTooltipContent = (0, _react2.useMemo)(() => {
    return (0, _ui.getRunWorkflowTooltipContent)(isValid, canRunWorkflow, isEnabled, false);
  }, [isValid, canRunWorkflow, isEnabled]);
  const handleRunClickWithUnsavedCheck = () => {
    if (hasUnsavedChanges) {
      setShowRunConfirmation(true);
    } else {
      handleRunClick();
    }
  };
  const handleConfirmRun = () => {
    setShowRunConfirmation(false);
    handleRunClick();
  };
  const handleCancelRun = () => {
    setShowRunConfirmation(false);
  };
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiPageTemplate, {
    offset: 0,
    minHeight: 0,
    grow: false,
    css: styles.pageTemplate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPageTemplate.Header, {
    css: styles.header,
    restrictWidth: false,
    bottomBorder: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPageHeaderSection, {
    css: styles.headerSection,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "m",
    css: styles.titleGroup,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: styles.titleItem,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonTitle, {
    size: "m",
    isLoading: isLoading,
    contentAriaLabel: name,
    css: styles.skeletonTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "m",
    css: styles.title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react2.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 21
    }
  }, name)))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonLoading, {
    isLoading: isLoading,
    loadingContent: /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonRectangle, {
      width: "80px",
      height: "20px",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 35
      }
    }),
    loadedContent: /*#__PURE__*/_react2.default.createElement(_workflow_unsaved_changes_badge.WorkflowUnsavedChangesBadge, {
      hasChanges: hasUnsavedChanges,
      highlightDiff: highlightDiff,
      setHighlightDiff: setHighlightDiff,
      lastUpdatedAt: lastUpdatedAt,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 21
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiPageHeaderSection, {
    css: {
      flexBasis: '15%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonGroup, {
    buttonSize: "compressed",
    color: "primary",
    options: buttonGroupOptions,
    idSelected: activeTab,
    legend: "Switch between workflow and executions",
    type: "single",
    onChange: id => handleTabChange(id),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiPageHeaderSection, {
    css: {
      flexBasis: '40%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: hasUnsavedChanges ? _i18n.i18n.translate('workflows.workflowDetailHeader.unsaved', {
      defaultMessage: 'Save changes to enable/disable workflow'
    }) : !isValid ? _i18n.i18n.translate('workflows.workflowDetailHeader.invalid', {
      defaultMessage: 'Fix errors to enable workflow'
    }) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSwitch, {
    disabled: isLoading || !canSaveWorkflow || !isValid || hasUnsavedChanges,
    checked: isEnabled,
    onChange: () => handleToggleWorkflow(),
    label: _i18n.i18n.translate('workflows.workflowDetailHeader.enabled', {
      defaultMessage: 'Enabled'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: styles.separator,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: runWorkflowTooltipContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    color: "success",
    display: "base",
    iconType: "play",
    size: "s",
    onClick: handleRunClickWithUnsavedCheck,
    disabled: !canRunWorkflow || !isEnabled || isLoading || !isValid,
    title: runWorkflowTooltipContent !== null && runWorkflowTooltipContent !== void 0 ? runWorkflowTooltipContent : undefined,
    "aria-label": _i18n.i18n.translate('workflows.workflowDetailHeader.runWorkflow.ariaLabel', {
      defaultMessage: 'Run workflow'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "primary",
    size: "s",
    onClick: handleSave,
    disabled: !canSaveWorkflow || isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "keepWorkflows.buttonText",
    defaultMessage: "Save",
    ignoreTag: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 17
    }
  })))))), showRunConfirmation && /*#__PURE__*/_react2.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('workflows.workflowDetailHeader.runWithUnsavedChanges.title', {
      defaultMessage: 'Run workflow with unsaved changes?'
    }),
    onCancel: handleCancelRun,
    onConfirm: handleConfirmRun,
    cancelButtonText: _i18n.i18n.translate('workflows.workflowDetailHeader.runWithUnsavedChanges.cancel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('workflows.workflowDetailHeader.runWithUnsavedChanges.confirm', {
      defaultMessage: 'Run workflow'
    }),
    buttonColor: "success",
    defaultFocusedButton: "confirm",
    "aria-label": _i18n.i18n.translate('workflows.workflowDetailHeader.runWithUnsavedChanges.title', {
      defaultMessage: 'Run workflow with unsaved changes?'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('workflows.workflowDetailHeader.runWithUnsavedChanges.message', {
    defaultMessage: 'You have unsaved changes. Running the workflow will not save your changes. Are you sure you want to continue?'
  }))));
};
exports.WorkflowDetailHeader = WorkflowDetailHeader;
const componentStyles = {
  pageTemplate: (0, _react.css)({
    flexGrow: 0
  }),
  header: ({
    euiTheme
  }) => (0, _react.css)({
    backgroundColor: euiTheme.colors.backgroundBasePlain,
    overflow: 'hidden',
    borderBottom: `1px solid ${euiTheme.colors.borderBasePlain}`,
    '@media (max-width: 1024px)': {
      flexDirection: 'column'
    },
    '& > div > div': {
      gap: '24px' // increase gap between title+badge and the "workflow/executions" toggle
    }
  }),
  headerSection: (0, _react.css)({
    flexBasis: '40%',
    overflow: 'hidden',
    whiteSpace: 'nowrap',
    width: '100%'
  }),
  separator: ({
    euiTheme
  }) => (0, _react.css)({
    width: '1px',
    margin: '4px 0',
    backgroundColor: euiTheme.colors.borderBasePlain,
    alignSelf: 'stretch'
  }),
  skeletonTitle: (0, _react.css)({
    minWidth: '250px',
    width: '100%',
    display: 'inline-block'
  }),
  title: (0, _react.css)({
    width: '100%',
    overflow: 'hidden',
    textOverflow: 'ellipsis',
    display: 'inline-block'
  }),
  titleGroup: (0, _react.css)({
    overflow: 'hidden'
  }),
  titleItem: (0, _react.css)({
    minWidth: 0,
    overflow: 'hidden'
  })
};