"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWorkflowsBreadcrumbs = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _common = require("../../../common");
var _use_kibana = require("../use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const workflowsTitle = _i18n.i18n.translate('workflows.breadcrumbs.title', {
  defaultMessage: 'Workflows'
});

/**
 * Sets the breadcrumbs for the Workflows app in app and in the document title.
 * If `workflowTitle` is provided, it will be appended to the breadcrumbs list.
 */
const useWorkflowsBreadcrumbs = workflowTitle => {
  const {
    chrome,
    application,
    serverless
  } = (0, _use_kibana.useKibana)().services;
  (0, _react.useEffect)(() => {
    const trailingBreadcrumbs = workflowTitle ? [{
      text: workflowTitle
    }] : [];
    if (serverless) {
      // In serverless, we leading breadcrumbs are managed by the serverless plugin, only the trailing breadcrumbs need to be set here
      serverless.setBreadcrumbs(trailingBreadcrumbs);
    } else {
      // In non-serverless, we need to set all the breadcrumbs, and the trailing breadcrumbs under "project" for the solution navigation mode
      const allBreadcrumbs = [{
        text: workflowsTitle,
        href: application === null || application === void 0 ? void 0 : application.getUrlForApp(_common.PLUGIN_ID),
        onClick: event => {
          if (event) {
            event.preventDefault();
          }
          application === null || application === void 0 ? void 0 : application.navigateToApp(_common.PLUGIN_ID);
        }
      }, ...trailingBreadcrumbs];
      chrome.setBreadcrumbs(allBreadcrumbs, {
        project: {
          value: trailingBreadcrumbs
        }
      });
    }
    // Apply the document title in any case
    chrome.docTitle.change([...(workflowTitle ? [workflowTitle] : []), workflowsTitle]);
  }, [chrome, application, serverless, workflowTitle]);
};
exports.useWorkflowsBreadcrumbs = useWorkflowsBreadcrumbs;