"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowVisualEditorStateful = WorkflowVisualEditorStateful;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _workflow_visual_editor = require("./workflow_visual_editor");
var _schema = require("../../../../common/schema");
var _yaml_utils = require("../../../../common/lib/yaml_utils");
var _use_workflow_execution = require("../../../entities/workflows/model/use_workflow_execution");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/workflow_visual_editor/ui/workflow_visual_editor_stateful.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function WorkflowVisualEditorStateful({
  workflowYaml,
  workflowExecutionId
}) {
  const {
    data: workflowExecution
  } = (0, _use_workflow_execution.useWorkflowExecution)(workflowExecutionId !== null && workflowExecutionId !== void 0 ? workflowExecutionId : null);
  const workflowYamlObject = (0, _react.useMemo)(() => {
    if (!workflowYaml) {
      return null;
    }
    const result = (0, _yaml_utils.parseWorkflowYamlToJSON)(workflowYaml, (0, _schema.getWorkflowZodSchemaLoose)());
    if (result.error) {
      return null;
    }
    return result.data;
  }, [workflowYaml]);
  if (!workflowYamlObject) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 45,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "workflows.visualEditor.invalidWorkflowYaml",
        defaultMessage: "Invalid workflow YAML",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "workflows.visualEditor.invalidWorkflowYamlBody",
        defaultMessage: "The workflow YAML is invalid. Please check the YAML and try again.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 11
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_workflow_visual_editor.WorkflowVisualEditor, {
    workflow: workflowYamlObject,
    stepExecutions: workflowExecution === null || workflowExecution === void 0 ? void 0 : workflowExecution.stepExecutions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  });
}