"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowsUtilityBar = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _use_workflow_bulk_actions = require("./use_workflow_bulk_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/workflow_list/ui/workflows_utility_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WorkflowsUtilityBar = ({
  totalWorkflows,
  selectedWorkflows,
  deselectWorkflows,
  onRefresh,
  showStart,
  showEnd
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react2.useState)(false);
  const togglePopover = (0, _react2.useCallback)(() => setIsPopoverOpen(!isPopoverOpen), [isPopoverOpen]);
  const closePopover = (0, _react2.useCallback)(() => setIsPopoverOpen(false), []);
  const onActionSuccess = (0, _react2.useCallback)(() => {
    onRefresh();
  }, [onRefresh]);
  const {
    panels,
    modals
  } = (0, _use_workflow_bulk_actions.useWorkflowBulkActions)({
    selectedWorkflows,
    onAction: closePopover,
    onActionSuccess
  });
  const showBulkActions = selectedWorkflows.length > 0;
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    css: (0, _react.css)`
          margin-top: ${euiTheme.size.s};
          padding-bottom: ${euiTheme.size.s};
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "workflows-table-count",
    grow: false,
    css: (0, _react.css)`
                border-right: ${euiTheme.border.thin};
                padding-right: ${euiTheme.size.s};
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('workflows.utilityBar.showingWorkflows', {
    defaultMessage: 'Showing {showStart}-{showEnd} of {total} workflows',
    values: {
      showStart,
      showEnd,
      total: totalWorkflows
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "workflows-table-utility-bar-actions",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 15
    }
  }, showBulkActions && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "workflows-table-selected-count",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 23
    }
  }, _i18n.i18n.translate('workflows.utilityBar.selectedWorkflows', {
    defaultMessage: '{count} selected',
    values: {
      count: selectedWorkflows.length
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    "data-test-subj": "workflows-table-bulk-actions-popover",
    button: /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      onClick: togglePopover,
      size: "s",
      iconSide: "right",
      iconType: "arrowDown",
      flush: "left",
      "data-test-subj": "workflows-table-bulk-actions-button",
      "aria-label": "Bulk actions",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 27
      }
    }, _i18n.i18n.translate('workflows.utilityBar.bulkActions', {
      defaultMessage: 'Bulk actions'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenu, {
    panels: panels,
    initialPanelId: 0,
    "data-test-subj": "workflows-table-bulk-actions-context-menu",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 25
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    onClick: deselectWorkflows,
    size: "s",
    iconSide: "left",
    iconType: "cross",
    flush: "left",
    "data-test-subj": "workflows-clear-selection-button",
    "aria-label": "Clear selection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 23
    }
  }, _i18n.i18n.translate('workflows.utilityBar.clearSelection', {
    defaultMessage: 'Clear selection'
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onRefresh,
    size: "s",
    iconSide: "left",
    iconType: "refresh",
    flush: "left",
    "data-test-subj": "workflows-refresh-button",
    "aria-label": "Refresh",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('workflows.utilityBar.refresh', {
    defaultMessage: 'Refresh'
  })))))))), modals);
};
exports.WorkflowsUtilityBar = WorkflowsUtilityBar;