"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowList = WorkflowList;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _react2 = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _components = require("../../../components");
var _use_workflow_actions = require("../../../entities/workflows/model/use_workflow_actions");
var _use_workflows = require("../../../entities/workflows/model/use_workflows");
var _ui = require("../../../shared/ui");
var _workflow_utils = require("../../../shared/utils/workflow_utils");
var _worflows_triggers_list = require("../../../widgets/worflows_triggers_list/worflows_triggers_list");
var _workflow_execute_modal = require("../../run_workflow/ui/workflow_execute_modal");
var _constants = require("../constants");
var _workflows_utility_bar = require("./workflows_utility_bar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/workflow_list/ui/workflow_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function WorkflowList({
  search,
  setSearch,
  onCreateWorkflow
}) {
  var _workflows$results;
  const {
    application,
    notifications
  } = (0, _public.useKibana)().services;
  const {
    data: workflows,
    isLoading: isLoadingWorkflows,
    error,
    refetch
  } = (0, _use_workflows.useWorkflows)(search);
  const {
    deleteWorkflows,
    runWorkflow,
    cloneWorkflow,
    updateWorkflow
  } = (0, _use_workflow_actions.useWorkflowActions)();
  const [selectedItems, setSelectedItems] = (0, _react2.useState)([]);
  const [executeWorkflow, setExecuteWorkflow] = (0, _react2.useState)(null);
  const canCreateWorkflow = application === null || application === void 0 ? void 0 : application.capabilities.workflowsManagement.createWorkflow;
  const canExecuteWorkflow = application === null || application === void 0 ? void 0 : application.capabilities.workflowsManagement.executeWorkflow;
  const canUpdateWorkflow = application === null || application === void 0 ? void 0 : application.capabilities.workflowsManagement.updateWorkflow;
  const canDeleteWorkflow = application === null || application === void 0 ? void 0 : application.capabilities.workflowsManagement.deleteWorkflow;
  const deselectWorkflows = (0, _react2.useCallback)(() => {
    setSelectedItems([]);
  }, []);
  const onRefresh = (0, _react2.useCallback)(async () => {
    var _result$data;
    const result = await refetch();
    // Update selected items with fresh data after refetch
    if ((_result$data = result.data) !== null && _result$data !== void 0 && _result$data.results && selectedItems.length > 0) {
      const selectedIds = selectedItems.map(item => item.id);
      const updatedSelectedItems = result.data.results.filter(workflow => selectedIds.includes(workflow.id));
      setSelectedItems(updatedSelectedItems);
    }
  }, [refetch, selectedItems]);
  const handleRunWorkflow = (0, _react2.useCallback)((id, event) => {
    runWorkflow.mutate({
      id,
      inputs: event
    }, {
      onSuccess: ({
        workflowExecutionId
      }) => {
        notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addSuccess('Workflow run started', {
          toastLifeTimeMs: 3000
        });
        application.navigateToUrl(application.getUrlForApp('workflows', {
          path: `/${id}?tab=executions&executionId=${workflowExecutionId}`
        }));
      },
      onError: err => {
        notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addError(err, {
          toastLifeTimeMs: 3000,
          title: 'Failed to run workflow'
        });
      }
    });
  }, [application, notifications, runWorkflow]);
  const handleDeleteWorkflow = (0, _react2.useCallback)(item => {
    const confirmed = window.confirm(`Are you sure you want to delete ${item.name}?`);
    if (!confirmed) {
      return;
    }
    deleteWorkflows.mutate({
      ids: [item.id]
    });
  }, [deleteWorkflows]);
  const handleCloneWorkflow = (0, _react2.useCallback)(item => {
    cloneWorkflow.mutate({
      id: item.id
    }, {
      onError: err => {
        notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addError(err, {
          toastLifeTimeMs: 3000,
          title: 'Failed to clone workflow'
        });
      }
    });
  }, [cloneWorkflow, notifications === null || notifications === void 0 ? void 0 : notifications.toasts]);
  const handleToggleWorkflow = (0, _react2.useCallback)(item => {
    updateWorkflow.mutate({
      id: item.id,
      workflow: {
        enabled: !item.enabled
      }
    }, {
      onError: err => {
        notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addError(err, {
          toastLifeTimeMs: 3000,
          title: 'Failed to update workflow'
        });
      }
    });
  }, [notifications === null || notifications === void 0 ? void 0 : notifications.toasts, updateWorkflow]);
  const columns = (0, _react2.useMemo)(() => [{
    field: 'name',
    name: 'Name',
    dataType: 'string',
    width: '45%',
    render: (name, item) => /*#__PURE__*/_react2.default.createElement("div", {
      css: (0, _react.css)`
              max-width: 100%;
              overflow: hidden;
            `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react2.default.createElement(_reactRouterDom.Link, {
      to: `/${item.id}`,
      css: (0, _react.css)`
                      white-space: nowrap;
                      overflow: hidden;
                      text-overflow: ellipsis;
                      display: block;
                      max-width: 100%;
                    `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 19
      }
    }, name))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued",
      title: item.description,
      css: (0, _react.css)`
                    white-space: nowrap;
                    overflow: hidden;
                    text-overflow: ellipsis;
                    max-width: 100%;
                    display: block;
                    width: 100%;
                  `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 17
      }
    }, item.description || /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "workflows.workflowList.noDescription",
      defaultMessage: "No description",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 21
      }
    })))))
  }, {
    field: 'tags',
    name: 'Tags',
    width: '15%',
    render: (value, item) => {
      var _item$definition;
      const tags = (_item$definition = item.definition) === null || _item$definition === void 0 ? void 0 : _item$definition.tags;
      if (!tags || tags.length === 0) {
        return null;
      }
      return tags.map(tag => /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
        key: tag,
        color: "hollow",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 221,
          columnNumber: 13
        }
      }, tag));
    }
  }, {
    field: 'triggers',
    name: 'Trigger',
    width: '16%',
    render: (value, item) => {
      var _item$definition$trig, _item$definition2;
      return /*#__PURE__*/_react2.default.createElement(_worflows_triggers_list.WorkflowsTriggersList, {
        triggers: (_item$definition$trig = (_item$definition2 = item.definition) === null || _item$definition2 === void 0 ? void 0 : _item$definition2.triggers) !== null && _item$definition$trig !== void 0 ? _item$definition$trig : [],
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 232,
          columnNumber: 11
        }
      });
    }
  }, {
    name: 'Last run',
    field: 'runHistory',
    width: '10%',
    render: (value, item) => {
      if (!item.history || item.history.length === 0) return;
      const lastRun = item.history[0];
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 243,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedRelative, {
        value: lastRun.finishedAt,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 244,
          columnNumber: 15
        }
      }));
    }
  }, {
    name: 'Last run status',
    field: 'runHistory',
    width: '12%',
    render: (value, item) => {
      if (!item.history || item.history.length === 0) return;
      return /*#__PURE__*/_react2.default.createElement(_ui.StatusBadge, {
        status: item.history[0].status,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 255,
          columnNumber: 18
        }
      });
    }
  }, {
    name: 'Enabled',
    field: 'enabled',
    width: '70px',
    render: (value, item) => {
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "s",
        responsive: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 264,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 265,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
        content: !item.valid ? _i18n.i18n.translate('workflows.workflowList.invalid', {
          defaultMessage: 'Fix errors to enable workflow'
        }) : undefined,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 266,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSwitch, {
        disabled: !canUpdateWorkflow || !item.valid,
        checked: item.enabled,
        onChange: () => handleToggleWorkflow(item),
        label: item.enabled ? _i18n.i18n.translate('workflows.workflowList.enabled', {
          defaultMessage: 'Enabled'
        }) : _i18n.i18n.translate('workflows.workflowList.disabled', {
          defaultMessage: 'Disabled'
        }),
        showLabel: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 275,
          columnNumber: 19
        }
      }))), !item.valid && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 294,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react2.default.createElement(_ui.WorkflowStatus, {
        valid: item.valid,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 295,
          columnNumber: 19
        }
      })));
    }
  }, {
    name: '',
    width: '120px',
    actions: [{
      isPrimary: true,
      enabled: item => !!canExecuteWorkflow && item.enabled && item.valid,
      type: 'icon',
      color: 'text',
      name: _i18n.i18n.translate('workflows.workflowList.run', {
        defaultMessage: 'Run'
      }),
      icon: 'play',
      description: item => {
        var _getRunWorkflowToolti;
        return (_getRunWorkflowToolti = (0, _ui.getRunWorkflowTooltipContent)(item.valid, !!canExecuteWorkflow, item.enabled, false)) !== null && _getRunWorkflowToolti !== void 0 ? _getRunWorkflowToolti : _i18n.i18n.translate('workflows.workflowList.run', {
          defaultMessage: 'Run'
        });
      },
      onClick: item => {
        var _item$definition3;
        let needInput = false;
        if ((_item$definition3 = item.definition) !== null && _item$definition3 !== void 0 && _item$definition3.triggers) {
          needInput = item.definition.triggers.some(trigger => trigger.type === 'alert') || item.definition.triggers.some(trigger => trigger.type === 'manual') && item.definition.inputs && Object.keys(item.definition.inputs).length > 0;
        }
        if (needInput) {
          setExecuteWorkflow(item);
        } else {
          handleRunWorkflow(item.id, {});
        }
      }
    }, {
      enabled: () => !!canUpdateWorkflow,
      type: 'icon',
      color: 'text',
      isPrimary: true,
      name: _i18n.i18n.translate('workflows.workflowList.edit', {
        defaultMessage: 'Edit'
      }),
      icon: 'pencil',
      description: _i18n.i18n.translate('workflows.workflowList.edit', {
        defaultMessage: 'Edit workflow'
      }),
      href: item => application.getUrlForApp('workflows', {
        path: `/${item.id}`
      })
    }, {
      enabled: () => !!canCreateWorkflow,
      type: 'icon',
      color: 'primary',
      name: _i18n.i18n.translate('workflows.workflowList.clone', {
        defaultMessage: 'Clone'
      }),
      icon: 'copy',
      description: _i18n.i18n.translate('workflows.workflowList.clone', {
        defaultMessage: 'Clone workflow'
      }),
      onClick: item => {
        handleCloneWorkflow(item);
      }
    }, {
      enabled: () => false,
      type: 'icon',
      color: 'primary',
      name: _i18n.i18n.translate('workflows.workflowList.export', {
        defaultMessage: 'Export'
      }),
      icon: 'export',
      description: _i18n.i18n.translate('workflows.workflowList.export', {
        defaultMessage: 'Export workflow'
      })
    }, {
      enabled: () => !!canDeleteWorkflow,
      type: 'icon',
      color: 'danger',
      name: _i18n.i18n.translate('workflows.workflowList.delete', {
        defaultMessage: 'Delete'
      }),
      icon: 'trash',
      description: _i18n.i18n.translate('workflows.workflowList.delete', {
        defaultMessage: 'Delete workflow'
      }),
      onClick: item => handleDeleteWorkflow(item)
    }]
  }], [application, canCreateWorkflow, canDeleteWorkflow, canExecuteWorkflow, canUpdateWorkflow, handleCloneWorkflow, handleDeleteWorkflow, handleRunWorkflow, setExecuteWorkflow, handleToggleWorkflow]);
  if (isLoadingWorkflows) {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: 'center',
      alignItems: 'center',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 409,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 410,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 411,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 413,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 414,
        columnNumber: 11
      }
    }, "Loading workflows...")));
  }
  if (error) {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 421,
        columnNumber: 12
      }
    }, "Error loading workflows");
  }

  // Show empty state if no workflows exist and no filters are applied
  if ((0, _workflow_utils.shouldShowWorkflowsEmptyState)(workflows, search)) {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      style: {
        minHeight: '60vh'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 427,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 428,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_components.WorkflowsEmptyState, {
      onCreateWorkflow: onCreateWorkflow,
      canCreateWorkflow: !!canCreateWorkflow,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 429,
        columnNumber: 11
      }
    })));
  }
  const showStart = (search.page - 1) * search.limit + 1;
  let showEnd = search.page * search.limit;
  if (showEnd > (workflows._pagination.total || 0)) {
    showEnd = workflows._pagination.total;
  }
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_workflows_utility_bar.WorkflowsUtilityBar, {
    totalWorkflows: (workflows === null || workflows === void 0 ? void 0 : workflows._pagination.total) || 0,
    selectedWorkflows: selectedItems,
    deselectWorkflows: deselectWorkflows,
    onRefresh: onRefresh,
    showStart: showStart,
    showEnd: showEnd,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 446,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 454,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiBasicTable, {
    css: (0, _react.css)`
          .euiBasicTableAction-showOnHover {
            opacity: 1 !important;
          }
        `,
    columns: columns,
    items: (_workflows$results = workflows === null || workflows === void 0 ? void 0 : workflows.results) !== null && _workflows$results !== void 0 ? _workflows$results : [],
    itemId: "id",
    responsiveBreakpoint: "xs",
    tableLayout: 'fixed',
    onChange: ({
      page: {
        index: pageIndex,
        size
      }
    }) => setSearch({
      ...search,
      page: pageIndex + 1,
      limit: size
    }),
    selection: {
      onSelectionChange: setSelectedItems,
      selectable: () => true,
      selected: selectedItems
    },
    pagination: {
      pageSize: search.limit,
      pageSizeOptions: _constants.WORKFLOWS_TABLE_PAGE_SIZE_OPTIONS,
      totalItemCount: workflows._pagination.total,
      pageIndex: search.page - 1
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 455,
      columnNumber: 7
    }
  }), executeWorkflow && /*#__PURE__*/_react2.default.createElement(_workflow_execute_modal.WorkflowExecuteModal, {
    definition: executeWorkflow.definition,
    onClose: () => setExecuteWorkflow(null),
    onSubmit: event => handleRunWorkflow(executeWorkflow.id, event),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 482,
      columnNumber: 9
    }
  }));
}