"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWorkflowBulkActions = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _use_workflow_actions = require("../../../entities/workflows/model/use_workflow_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/workflow_list/ui/use_workflow_bulk_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useWorkflowBulkActions = ({
  selectedWorkflows,
  onAction,
  onActionSuccess
}) => {
  const {
    application
  } = (0, _public.useKibana)().services;
  const {
    deleteWorkflows,
    updateWorkflow
  } = (0, _use_workflow_actions.useWorkflowActions)();
  const [showDeleteModal, setShowDeleteModal] = (0, _react.useState)(false);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const canDeleteWorkflow = application === null || application === void 0 ? void 0 : application.capabilities.workflowsManagement.deleteWorkflow;
  const canUpdateWorkflow = application === null || application === void 0 ? void 0 : application.capabilities.workflowsManagement.updateWorkflow;
  const isDisabled = selectedWorkflows.length === 0;
  const handleDeleteWorkflows = (0, _react.useCallback)(() => {
    onAction();
    setShowDeleteModal(true);
  }, [onAction]);
  const confirmDelete = (0, _react.useCallback)(() => {
    const ids = selectedWorkflows.map(workflow => workflow.id);
    deleteWorkflows.mutate({
      ids
    }, {
      onSuccess: () => {
        setShowDeleteModal(false);
        onActionSuccess();
      },
      onError: () => {
        setShowDeleteModal(false);
      }
    });
  }, [selectedWorkflows, deleteWorkflows, onActionSuccess]);
  const cancelDelete = (0, _react.useCallback)(() => {
    setShowDeleteModal(false);
  }, []);
  const bulkUpdateWorkflows = (0, _react.useCallback)((workflowsToUpdate, updateData) => {
    onAction();
    const updatePromises = workflowsToUpdate.map(workflow => new Promise(resolve => {
      updateWorkflow.mutate({
        id: workflow.id,
        workflow: updateData
      }, {
        onSettled: () => {
          resolve();
        }
      });
    }));
    Promise.allSettled(updatePromises).then(() => {
      onActionSuccess();
    });
  }, [updateWorkflow, onAction, onActionSuccess]);
  const handleEnableWorkflows = (0, _react.useCallback)(() => {
    const disabledWorkflows = selectedWorkflows.filter(workflow => !workflow.enabled);
    bulkUpdateWorkflows(disabledWorkflows, {
      enabled: true
    });
  }, [selectedWorkflows, bulkUpdateWorkflows]);
  const handleDisableWorkflows = (0, _react.useCallback)(() => {
    const enabledWorkflows = selectedWorkflows.filter(workflow => workflow.enabled);
    bulkUpdateWorkflows(enabledWorkflows, {
      enabled: false
    });
  }, [selectedWorkflows, bulkUpdateWorkflows]);
  const panels = (0, _react.useMemo)(() => {
    const mainPanelItems = [];
    const hasDisabledWorkflows = selectedWorkflows.some(workflow => !workflow.enabled);
    const hasEnabledWorkflows = selectedWorkflows.some(workflow => workflow.enabled);
    if (canUpdateWorkflow && hasDisabledWorkflows) {
      mainPanelItems.push({
        name: _i18n.i18n.translate('workflows.bulkActions.enable', {
          defaultMessage: 'Enable'
        }),
        icon: 'play',
        disabled: isDisabled,
        onClick: handleEnableWorkflows,
        'data-test-subj': 'workflows-bulk-action-enable',
        key: 'workflows-bulk-action-enable'
      });
    }
    if (canUpdateWorkflow && hasEnabledWorkflows) {
      mainPanelItems.push({
        name: _i18n.i18n.translate('workflows.bulkActions.disable', {
          defaultMessage: 'Disable'
        }),
        icon: 'pause',
        disabled: isDisabled,
        onClick: handleDisableWorkflows,
        'data-test-subj': 'workflows-bulk-action-disable',
        key: 'workflows-bulk-action-disable'
      });
    }
    if (canUpdateWorkflow && canDeleteWorkflow && mainPanelItems.length > 0) {
      mainPanelItems.push({
        isSeparator: true,
        key: 'bulk-actions-separator',
        'data-test-subj': 'bulk-actions-separator'
      });
    }
    if (canDeleteWorkflow) {
      mainPanelItems.push({
        name: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
          color: "danger",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 153,
            columnNumber: 11
          }
        }, _i18n.i18n.translate('workflows.bulkActions.delete', {
          defaultMessage: 'Delete'
        })),
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "trash",
          size: "m",
          color: "danger",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 159,
            columnNumber: 15
          }
        }),
        disabled: isDisabled,
        onClick: handleDeleteWorkflows,
        'data-test-subj': 'workflows-bulk-action-delete',
        key: 'workflows-bulk-action-delete'
      });
    }
    return [{
      id: 0,
      items: mainPanelItems,
      title: _i18n.i18n.translate('workflows.bulkActions.title', {
        defaultMessage: 'Actions'
      })
    }];
  }, [selectedWorkflows, canUpdateWorkflow, canDeleteWorkflow, isDisabled, handleEnableWorkflows, handleDisableWorkflows, handleDeleteWorkflows]);
  const modals = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showDeleteModal && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      title: _i18n.i18n.translate('workflows.bulkActions.deleteModal.title', {
        defaultMessage: 'Delete {count} workflows?',
        values: {
          count: selectedWorkflows.length
        }
      }),
      titleProps: {
        id: modalTitleId
      },
      "aria-labelledby": modalTitleId,
      onCancel: cancelDelete,
      onConfirm: confirmDelete,
      cancelButtonText: _i18n.i18n.translate('workflows.bulkActions.deleteModal.cancel', {
        defaultMessage: 'Cancel'
      }),
      confirmButtonText: _i18n.i18n.translate('workflows.bulkActions.deleteModal.confirm', {
        defaultMessage: 'Delete'
      }),
      buttonColor: "danger",
      defaultFocusedButton: "cancel",
      "data-test-subj": "workflows-bulk-delete-modal",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 209,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('workflows.bulkActions.deleteModal.message', {
      defaultMessage: 'You are about to delete {count} workflows. This action cannot be undone.',
      values: {
        count: selectedWorkflows.length
      }
    }))));
  }, [showDeleteModal, selectedWorkflows.length, cancelDelete, confirmDelete, modalTitleId]);
  return {
    panels,
    modals
  };
};
exports.useWorkflowBulkActions = useWorkflowBulkActions;