"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowExecutionStatsBar = WorkflowExecutionStatsBar;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _workflows = require("@kbn/workflows");
var _formatters = require("@elastic/charts/dist/utils/data/formatters");
var _use_workflow_stats = require("../../../entities/workflows/model/use_workflow_stats");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/workflow_executions_stats/ui/workflow_executions_stats_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function WorkflowExecutionStatsBar({
  height
}) {
  const {
    data,
    isLoading
  } = (0, _use_workflow_stats.useWorkflowStats)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (isLoading || data === undefined) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
      offset: 0,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 12
      }
    });
  }
  if (data.executions.length === 0) {
    return null;
  }
  const executionStats = [];
  data.executions.forEach((day, index) => {
    executionStats.push({
      timestamp: day.timestamp,
      count: day.completed,
      label: _workflows.ExecutionStatus.COMPLETED
    });
    executionStats.push({
      timestamp: day.timestamp,
      count: day.failed,
      label: _workflows.ExecutionStatus.FAILED
    });
    executionStats.push({
      timestamp: day.timestamp,
      count: day.cancelled,
      label: _workflows.ExecutionStatus.CANCELLED
    });
  });
  const timestamps = executionStats.map(d => d.timestamp);
  const dateFormatter = (0, _charts.niceTimeFormatter)([Math.min(...timestamps), Math.max(...timestamps)]);
  const tooltipTimeFormatter = (0, _formatters.timeFormatter)('HH:MM:SS');
  const colorMap = {
    [_workflows.ExecutionStatus.COMPLETED]: euiTheme.colors.vis.euiColorVis0,
    [_workflows.ExecutionStatus.FAILED]: euiTheme.colors.vis.euiColorVis6,
    [_workflows.ExecutionStatus.CANCELLED]: euiTheme.colors.vis.euiColorVis8,
    [_workflows.ExecutionStatus.TIMED_OUT]: euiTheme.colors.vis.euiColorVis6,
    [_workflows.ExecutionStatus.PENDING]: euiTheme.colors.vis.euiColorVis1,
    [_workflows.ExecutionStatus.WAITING]: euiTheme.colors.vis.euiColorVis1,
    [_workflows.ExecutionStatus.WAITING_FOR_INPUT]: euiTheme.colors.vis.euiColorVis1,
    [_workflows.ExecutionStatus.RUNNING]: euiTheme.colors.vis.euiColorVis1,
    [_workflows.ExecutionStatus.SKIPPED]: euiTheme.colors.vis.euiColorVis1
  };
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: height || 200,
      width: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: true,
    legendPosition: _charts.Position.Right,
    theme: {
      scales: {
        barsPadding: 0.2
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    headerFormatter: ({
      value
    }) => tooltipTimeFormatter(value),
    type: "follow",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom-axis",
    position: _charts.Position.Bottom,
    title: "@timestamp",
    tickFormat: dateFormatter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left-axis",
    position: _charts.Position.Left,
    title: "Executions",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "workflows-executions-stats",
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "timestamp",
    yAccessors: ['count'],
    data: executionStats !== null && executionStats !== void 0 ? executionStats : [],
    splitSeriesAccessors: ['label'],
    stackAccessors: ['timestamp'],
    color: ({
      seriesKeys
    }) => {
      const status = seriesKeys[0];
      return colorMap[status] || euiTheme.colors.textParagraph;
    },
    enableHistogramMode: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }));
}