"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowExecutionList = WorkflowExecutionList;
var _react = _interopRequireWildcard(require("react"));
var _workflows = require("@kbn/workflows");
var _use_workflow_executions = require("../../../entities/workflows/model/use_workflow_executions");
var _use_workflow_url_state = require("../../../hooks/use_workflow_url_state");
var _workflow_execution_list = require("./workflow_execution_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/workflow_execution_list/ui/workflow_execution_list_stateful.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EXECUTIONS_LIST_REFETCH_INTERVAL = 5000;
const EXECUTIONS_LIST_REFETCH_INTERVAL_ACTIVE = 1000;
const DEFAULT_FILTERS = {
  statuses: [],
  executionTypes: []
};
function WorkflowExecutionList({
  workflowId
}) {
  const [refetchInterval, setRefetchInterval] = (0, _react.useState)(EXECUTIONS_LIST_REFETCH_INTERVAL);
  const [filters, setFilters] = (0, _react.useState)(DEFAULT_FILTERS);
  const {
    data: workflowExecutions,
    isLoading: isLoadingWorkflowExecutions,
    error
  } = (0, _use_workflow_executions.useWorkflowExecutions)({
    workflowId,
    statuses: filters.statuses,
    executionTypes: filters.executionTypes
  }, {
    refetchInterval
  });
  (0, _react.useEffect)(() => {
    if (!workflowExecutions) {
      return;
    }
    const activeExecutions = workflowExecutions.results.some(execution => [_workflows.ExecutionStatus.PENDING, _workflows.ExecutionStatus.RUNNING, _workflows.ExecutionStatus.WAITING_FOR_INPUT].includes(execution.status));

    // If there are active executions, refetch more frequently
    if (activeExecutions) {
      setRefetchInterval(EXECUTIONS_LIST_REFETCH_INTERVAL_ACTIVE);
    } else {
      setRefetchInterval(EXECUTIONS_LIST_REFETCH_INTERVAL);
    }
  }, [workflowExecutions]);
  const {
    selectedExecutionId,
    setSelectedExecution
  } = (0, _use_workflow_url_state.useWorkflowUrlState)();
  const handleViewWorkflowExecution = executionId => {
    setSelectedExecution(executionId);
  };
  return /*#__PURE__*/_react.default.createElement(_workflow_execution_list.WorkflowExecutionList, {
    executions: workflowExecutions !== null && workflowExecutions !== void 0 ? workflowExecutions : null,
    onExecutionClick: handleViewWorkflowExecution,
    selectedId: selectedExecutionId !== null && selectedExecutionId !== void 0 ? selectedExecutionId : null,
    isLoading: isLoadingWorkflowExecutions,
    error: error,
    filters: filters,
    onFiltersChange: setFilters,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  });
}