"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowExecutionListItem = void 0;
var _eui = require("@elastic/eui");
var _workflows = require("@kbn/workflows");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _use_formatted_date = require("../../../shared/ui/use_formatted_date");
var _translations = require("../../../shared/translations");
var _status_badge = require("../../../shared/ui/status_badge");
var _format_duration = require("../../../shared/lib/format_duration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/workflow_execution_list/ui/workflow_execution_list_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WorkflowExecutionListItem = ({
  status,
  startedAt,
  duration,
  selected = false,
  onClick
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const getFormattedDate = (0, _use_formatted_date.useGetFormattedDateTime)();
  const formattedDate = startedAt ? getFormattedDate(startedAt) : null;
  const formattedDuration = (0, _react.useMemo)(() => {
    if (duration) {
      return (0, _format_duration.formatDuration)(duration);
    }
    return null;
  }, [duration]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    component: "a",
    css: [styles.baseContainer, selected && styles.selectedContainer, !selected && onClick && styles.selectableContainer],
    alignItems: "center",
    justifyContent: "flexStart",
    onClick: onClick !== null && onClick !== void 0 ? onClick : undefined,
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.iconContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, (0, _status_badge.getExecutionStatusIcon)(euiTheme, status)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.contentContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    css: styles.content,
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    css: [styles.header, (status === _workflows.ExecutionStatus.FAILED || status === _workflows.ExecutionStatus.CANCELLED) && {
      color: (0, _status_badge.getExecutionStatusColors)(euiTheme, status).color
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  }, (0, _translations.getStatusLabel)(status))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.timestamp,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, startedAt ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "right",
    content: formattedDate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
    value: startedAt,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 17
    }
  })) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "workflows.workflowExecutionListItem.notStarted",
    defaultMessage: "Not started",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    gutterSize: "xs",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    css: styles.duration,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }, formattedDuration)), onClick ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "arrowRight",
    color: euiTheme.colors.backgroundFilledText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 15
    }
  })) : null)));
};
exports.WorkflowExecutionListItem = WorkflowExecutionListItem;
const componentStyles = {
  baseContainer: ({
    euiTheme
  }) => (0, _react2.css)({
    padding: euiTheme.size.m,
    borderRadius: euiTheme.border.radius.medium,
    gap: euiTheme.size.m,
    flexGrow: 0,
    border: `1px solid ${euiTheme.colors.borderBasePlain}`
  }),
  selectedContainer: ({
    euiTheme
  }) => (0, _react2.css)({
    backgroundColor: euiTheme.colors.backgroundBaseInteractiveSelect
  }),
  selectableContainer: ({
    euiTheme
  }) => (0, _react2.css)({
    backgroundColor: euiTheme.colors.backgroundBasePlain,
    cursor: 'pointer',
    '&:hover': {
      backgroundColor: euiTheme.colors.backgroundBaseInteractiveHover
    }
  }),
  iconContainer: (0, _react2.css)({
    flexGrow: 0,
    width: '16px',
    height: '16px'
  }),
  contentContainer: (0, _react2.css)({
    flex: 1
  }),
  content: euiThemeContext => (0, _react2.css)({
    flexGrow: 0,
    flexShrink: 1,
    fontSize: (0, _eui.euiFontSize)(euiThemeContext, 's').fontSize
  }),
  header: ({
    euiTheme
  }) => (0, _react2.css)({
    fontWeight: 'bold',
    color: euiTheme.colors.textParagraph
  }),
  timestamp: ({
    euiTheme
  }) => (0, _react2.css)({
    alignSelf: 'flex-start',
    color: euiTheme.colors.textSubdued
  }),
  duration: ({
    euiTheme
  }) => (0, _react2.css)({
    color: euiTheme.colors.textSubdued
  })
};