"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowExecutionList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _workflow_execution_list_item = require("./workflow_execution_list_item");
var _workflow_execution_list_filters = require("./workflow_execution_list_filters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/workflow_execution_list/ui/workflow_execution_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// TODO: use custom table? add pagination and search

const emptyPromptCommonProps = {
  titleSize: 'xs',
  paddingSize: 'm'
};
const WorkflowExecutionList = ({
  filters,
  onFiltersChange,
  isLoading,
  error,
  executions,
  onExecutionClick,
  selectedId
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  let content = null;
  if (isLoading) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, (0, _extends2.default)({}, emptyPromptCommonProps, {
      css: styles.container,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "l",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 15
        }
      }),
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "workflows.workflowExecutionList.loadingExecutions",
        defaultMessage: "Loading executions...",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 13
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 7
      }
    }));
  } else if (error) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, (0, _extends2.default)({}, emptyPromptCommonProps, {
      css: styles.container,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "error",
        size: "l",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 15
        }
      }),
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "workflows.workflowExecutionList.errorLoadingExecutions",
        defaultMessage: "Error loading workflow executions",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 15
        }
      }, error.message),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 7
      }
    }));
  } else if (!executions || !executions.results.length) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, (0, _extends2.default)({}, emptyPromptCommonProps, {
      css: styles.container,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "play",
        size: "l",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 15
        }
      }),
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "workflows.workflowExecutionList.noExecutionsFound",
        defaultMessage: "No executions found",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "workflows.workflowExecutionList.noExecutionsFoundDescription",
        defaultMessage: "Workflow has not been executed yet.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 106,
          columnNumber: 13
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 7
      }
    }));
  } else {
    content = executions.results.map(execution => /*#__PURE__*/_react.default.createElement(_workflow_execution_list_item.WorkflowExecutionListItem, {
      key: execution.id,
      status: execution.status,
      startedAt: new Date(execution.startedAt),
      duration: execution.duration,
      selected: execution.id === selectedId,
      onClick: () => onExecutionClick(execution.id),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 7
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    justifyContent: "flexStart",
    css: styles.container,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("header", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "workflows.workflowExecutionList.title",
    defaultMessage: "Execution history",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_workflow_execution_list_filters.ExecutionListFilters, {
    filters: filters,
    onFiltersChange: onFiltersChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 13
    }
  })))), content);
};
exports.WorkflowExecutionList = WorkflowExecutionList;
const componentStyles = {
  container: ({
    euiTheme
  }) => (0, _react2.css)({
    padding: euiTheme.size.m,
    overflowY: 'auto'
  })
};