"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowStepExecutionList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _workflows = require("@kbn/workflows");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _i18n = require("@kbn/i18n");
var _step_execution_tree_item_label = require("./step_execution_tree_item_label");
var _status_badge = require("../../../shared/ui/status_badge");
var _step_icon = require("../../../shared/ui/step_icon");
var _build_step_executions_tree = require("./build_step_executions_tree");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/workflow_execution_detail/ui/workflow_step_execution_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// handle special nodes like foreachstep:0, foreachstep:1, if:true, if:false
function getStepStatus(item, status) {
  const stepType = item.stepType;
  if ((stepType === 'foreach-iteration' || stepType === 'foreach' || stepType === 'if-branch' || stepType === 'if') && !item.children.length && !(0, _workflows.isInProgressStatus)(status !== null && status !== void 0 ? status : _workflows.ExecutionStatus.PENDING)) {
    return _workflows.ExecutionStatus.SKIPPED;
  }
  if (status) {
    return status;
  }
  return null;
}
function convertTreeToEuiTreeViewItems(treeItems, stepExecutionMap, euiTheme, selectedId, onClickHandler) {
  const onClickFn = onClickHandler;
  return treeItems.map(item => {
    var _item$stepExecutionId, _stepExecution$status, _item$stepExecutionId2, _stepExecution$execut;
    const stepExecution = stepExecutionMap.get((_item$stepExecutionId = item.stepExecutionId) !== null && _item$stepExecutionId !== void 0 ? _item$stepExecutionId : '');
    const status = getStepStatus(item, (_stepExecution$status = stepExecution === null || stepExecution === void 0 ? void 0 : stepExecution.status) !== null && _stepExecution$status !== void 0 ? _stepExecution$status : null);
    return {
      ...item,
      id: (_item$stepExecutionId2 = item.stepExecutionId) !== null && _item$stepExecutionId2 !== void 0 ? _item$stepExecutionId2 : `${item.stepId}-${item.executionIndex}-no-step-execution`,
      icon: /*#__PURE__*/_react.default.createElement(_step_icon.StepIcon, {
        stepType: item.stepType,
        executionStatus: status,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 13
        }
      }),
      css: status && (0, _workflows.isDangerousStatus)(status) ? (0, _react2.css)`
              &,
              &:active,
              &:focus {
                background-color: ${(0, _status_badge.getExecutionStatusColors)(euiTheme, status).backgroundColor};
              }

              &:hover {
                background-color: ${euiTheme.colors.backgroundLightDanger};
              }
            ` : undefined,
      label: /*#__PURE__*/_react.default.createElement(_step_execution_tree_item_label.StepExecutionTreeItemLabel, {
        stepId: item.stepId,
        status: status,
        executionIndex: item.executionIndex,
        executionTimeMs: (_stepExecution$execut = stepExecution === null || stepExecution === void 0 ? void 0 : stepExecution.executionTimeMs) !== null && _stepExecution$execut !== void 0 ? _stepExecution$execut : null,
        stepType: item.stepType,
        selected: selectedId === (stepExecution === null || stepExecution === void 0 ? void 0 : stepExecution.id),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 9
        }
      }),
      children: item.children.length > 0 ? convertTreeToEuiTreeViewItems(item.children, stepExecutionMap, euiTheme, selectedId, onClickFn) : undefined,
      callback:
      // TODO: for nodes with children, we don't want other onClick behavior besides expanding/collapsing
      () => {
        var _toOpen, _toOpen2;
        let toOpen = item.stepExecutionId;
        if (!toOpen && item.children.length) {
          toOpen = item.children[0].stepExecutionId;
        }
        onClickFn((_toOpen = toOpen) !== null && _toOpen !== void 0 ? _toOpen : '');
        // string is expected by EuiTreeView for some reason
        return (_toOpen2 = toOpen) !== null && _toOpen2 !== void 0 ? _toOpen2 : '';
      }
    };
  });
}
const emptyPromptCommonProps = {
  titleSize: 'xs',
  paddingSize: 's'
};
const WorkflowStepExecutionList = ({
  isLoading,
  error,
  execution,
  definition,
  onStepExecutionClick,
  selectedId,
  onClose
}) => {
  var _execution$stepExecut;
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  let content = null;
  if (isLoading || !execution) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, (0, _extends2.default)({}, emptyPromptCommonProps, {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "l",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 152,
          columnNumber: 15
        }
      }),
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 154,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "workflows.workflowStepExecutionList.loadingStepExecutions",
        defaultMessage: "Loading step executions...",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 155,
          columnNumber: 13
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 7
      }
    }));
  } else if (error) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, (0, _extends2.default)({}, emptyPromptCommonProps, {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "error",
        size: "l",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 15
        }
      }),
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "workflows.workflowStepExecutionList.errorLoadingStepExecutions",
        defaultMessage: "Error loading step executions",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 170,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 176,
          columnNumber: 15
        }
      }, error.message),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 7
      }
    }));
  } else if ((execution === null || execution === void 0 ? void 0 : (_execution$stepExecut = execution.stepExecutions) === null || _execution$stepExecut === void 0 ? void 0 : _execution$stepExecut.length) === 0 && !(0, _workflows.isInProgressStatus)(execution === null || execution === void 0 ? void 0 : execution.status)) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, (0, _extends2.default)({}, emptyPromptCommonProps, {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "list",
        size: "l",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 183,
          columnNumber: 15
        }
      }),
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 185,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "workflows.workflowStepExecutionList.noExecutionFound",
        defaultMessage: "No step executions found",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 186,
          columnNumber: 13
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 7
      }
    }));
  } else if (definition) {
    const skeletonStepExecutions = definition.steps.map((step, index) => ({
      stepId: step.name,
      stepType: step.type,
      status: _workflows.ExecutionStatus.PENDING,
      id: `${step.name}-${step.type}-${index}`,
      scopeStack: [],
      workflowRunId: '',
      workflowId: '',
      startedAt: '',
      finishedAt: '',
      children: [],
      globalExecutionIndex: 0,
      stepExecutionIndex: 0,
      topologicalIndex: 0
    }));
    const stepExecutionMap = new Map();
    const stepExecutionNameMap = new Map();
    for (const stepExecution of execution.stepExecutions) {
      stepExecutionNameMap.set(stepExecution.stepId, stepExecution);
      stepExecutionMap.set(stepExecution.id, stepExecution);
    }
    for (const skeletonStepExecution of skeletonStepExecutions) {
      if (!stepExecutionNameMap.has(skeletonStepExecution.stepId)) {
        stepExecutionMap.set(skeletonStepExecution.id, skeletonStepExecution);
      }
    }
    const stepExecutionsTree = (0, _build_step_executions_tree.buildStepExecutionsTree)(Array.from(stepExecutionMap.values()));
    const items = convertTreeToEuiTreeViewItems(stepExecutionsTree, stepExecutionMap, euiTheme, selectedId, onStepExecutionClick);
    content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      css: styles.treeViewContainer,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTreeView, {
      showExpansionArrows: true,
      expandByDefault: true,
      items: items,
      "aria-label": _i18n.i18n.translate('workflows.workflowStepExecutionList.workflowStepExecutionTreeAriaLabel', {
        defaultMessage: 'Workflow step execution tree'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 11
      }
    })));
  } else {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, (0, _extends2.default)({}, emptyPromptCommonProps, {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "error",
        size: "l",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 252,
          columnNumber: 15
        }
      }),
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 254,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "workflows.workflowStepExecutionList.errorLoadingStepExecutions",
        defaultMessage: "Error loading execution graph",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 255,
          columnNumber: 13
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 7
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    justifyContent: "flexStart",
    css: styles.container,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.content,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 7
    }
  }, content));
};
exports.WorkflowStepExecutionList = WorkflowStepExecutionList;
const componentStyles = {
  container: (0, _react2.css)({
    overflow: 'hidden'
  }),
  content: (0, _react2.css)({
    overflow: 'hidden'
  }),
  treeViewContainer: ({
    euiTheme
  }) => (0, _react2.css)`
    overflow-y: auto;

    & .euiTreeView__nodeLabel {
      flex-grow: 1;
      text-align: left;
    }
    & .euiTreeView__nodeInner {
      gap: 6px;
      /* Absolutely position the horizontal tick connecting the item to the vertical line. */
      position: relative;
      padding-inline: ${euiTheme.size.s};

      &::after {
        position: absolute;
        content: '';
        ${(0, _eui.logicalCSS)('top', '14px')}
        ${(0, _eui.logicalCSS)('left', 0)}
        ${(0, _eui.logicalCSS)('width', euiTheme.size.s)}
        ${(0, _eui.logicalCSS)('border-bottom', euiTheme.border.thin)}
      }
    }
    & .euiTreeView {
      // TODO: reduce padding to fit more nested levels in 300px sidebar?
      padding-inline-start: ${euiTheme.size.m} !important;
    }

    & .euiTreeView__node {
      position: relative;

      /* Draw the vertical line to group an expanded item's child items together. */
      &::after {
        position: absolute;
        content: '';
        ${(0, _eui.logicalCSS)('vertical', 0)}
        ${(0, _eui.logicalCSS)('left', 0)}
        ${(0, _eui.logicalCSS)('border-left', euiTheme.border.thin)}
      }

      /* If this is actually the last item, we don't want the vertical line to stretch all the way down */
      &:last-of-type::after {
        ${(0, _eui.logicalCSS)('height', '14px')}
      }
    }

    & > ul > li {
      // for the first level of the tree, we don't want lines
      &::after {
        display: none;
      }
      & > .euiTreeView__nodeInner::after {
        display: none;
      }
    }
  `
};