"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepExecutionTimelineStateful = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_workflow_execution_logs = require("../../../entities/workflows/api/use_workflow_execution_logs");
var _step_execution_timeline = require("./step_execution_timeline");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/workflow_execution_detail/ui/step_execution_timeline_stateful.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const StepExecutionTimelineStateful = ({
  executionId,
  stepExecutionId
}) => {
  var _logsData$logs;
  const {
    data: logsData,
    isLoading,
    error
  } = (0, _use_workflow_execution_logs.useWorkflowExecutionLogs)({
    executionId,
    stepExecutionId,
    limit: 100,
    // Get more logs without pagination
    offset: 0,
    enabled: true,
    sortOrder: 'asc'
  });
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const containerCss = {
    padding: euiTheme.size.s
  };
  const emptyPromptCommonProps = {
    titleSize: 'xs',
    paddingSize: 's'
  };
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, (0, _extends2.default)({}, emptyPromptCommonProps, {
      css: containerCss,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "l",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 15
        }
      }),
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "workflows.stepExecutionTimeline.loadingLogs",
        defaultMessage: "Loading logs...",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 13
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 7
      }
    }));
  }
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, (0, _extends2.default)({}, emptyPromptCommonProps, {
      css: containerCss,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "error",
        size: "l",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 15
        }
      }),
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "workflows.stepExecutionTimeline.errorLoadingLogs",
        defaultMessage: "Error loading logs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 13
        }
      })),
      body: error instanceof Error ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 13
        }
      }, error.message) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 13
        }
      }, "Unknown error"),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 7
      }
    }));
  }
  if (!(logsData !== null && logsData !== void 0 && (_logsData$logs = logsData.logs) !== null && _logsData$logs !== void 0 && _logsData$logs.length)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, (0, _extends2.default)({}, emptyPromptCommonProps, {
      css: containerCss,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "info",
        size: "l",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 15
        }
      }),
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "workflows.stepExecutionTimeline.noLogsFound",
        defaultMessage: "No logs found",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 13
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 7
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_step_execution_timeline.StepExecutionTimeline, {
    logs: logsData.logs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 10
    }
  });
};
exports.StepExecutionTimelineStateful = StepExecutionTimelineStateful;