"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getWorkflowContextSchema = getWorkflowContextSchema;
var _workflows = require("@kbn/workflows");
var _zod = require("@kbn/zod");
var _zod2 = require("../../../../common/lib/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getWorkflowContextSchema(definition) {
  var _definition$consts;
  return _workflows.WorkflowContextSchema.extend({
    // transform an array of inputs to an object
    // with the input name as the key and the defined type as the value
    inputs: _zod.z.object({
      ...Object.fromEntries((definition.inputs || []).map(input => {
        var _input$options;
        let valueSchema;
        switch (input.type) {
          case 'string':
            valueSchema = _zod.z.string();
            break;
          case 'number':
            valueSchema = _zod.z.number();
            break;
          case 'boolean':
            valueSchema = _zod.z.boolean();
            break;
          case 'choice':
            const opts = (_input$options = input.options) !== null && _input$options !== void 0 ? _input$options : [];
            valueSchema = _zod.z.any();
            if (opts.length > 0) {
              const literals = opts.map(o => _zod.z.literal(o));
              valueSchema = _zod.z.union(literals);
            }
            break;
          default:
            valueSchema = _zod.z.any();
            break;
        }
        if (input.default) {
          valueSchema = valueSchema.default(input.default);
        }
        return [input.name, valueSchema];
      }))
    }),
    // transform an object of consts to an object
    // with the const name as the key and inferred type as the value
    consts: _zod.z.object({
      ...Object.fromEntries(Object.entries((_definition$consts = definition.consts) !== null && _definition$consts !== void 0 ? _definition$consts : {}).map(([key, value]) => [key, (0, _zod2.inferZodType)(value)]))
    })
  });
}