"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowExecuteModal = WorkflowExecuteModal;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _capitalize = _interopRequireDefault(require("lodash/capitalize"));
var _translations = require("../../../../common/translations");
var _workflow_execute_event_form = require("./workflow_execute_event_form");
var _workflow_execute_manual_form = require("./workflow_execute_manual_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/run_workflow/ui/workflow_execute_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function WorkflowExecuteModal({
  definition,
  onClose,
  onSubmit
}) {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const enabledTriggers = (definition === null || definition === void 0 ? void 0 : definition.triggers.filter(t => t.enabled).map(t => t.type)) || [];
  const [selectedTrigger, setSelectedTrigger] = (0, _react.useState)(enabledTriggers[0]);
  const [executionInput, setExecutionInput] = (0, _react.useState)('');
  const [executionInputErrors, setExecutionInputErrors] = (0, _react.useState)(null);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const handleSubmit = () => {
    onSubmit(JSON.parse(executionInput));
    onClose();
  };
  const handleChangeTrigger = trigger => {
    setExecutionInput('');
    setSelectedTrigger(trigger);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-labelledby": modalTitleId,
    onClose: onClose,
    maxWidth: 1400,
    style: {
      width: '1200px',
      height: '100vh'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, "Run Workflow")), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, enabledTriggers.map(trigger => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: trigger,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: selectedTrigger === trigger ? 'primary' : 'text',
    onClick: () => handleChangeTrigger(trigger),
    iconSide: "right",
    contentProps: {
      style: {
        justifyContent: 'flex-start',
        flexDirection: 'column',
        alignItems: 'flex-start',
        padding: selectedTrigger === trigger ? '10px' : '9px',
        textAlign: 'left'
      }
    },
    css: (0, _react2.css)`
                  width: 100%;
                  height: fit-content;
                  svg,
                  img {
                    margin-left: auto;
                  }
                `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    name: (0, _capitalize.default)(trigger),
    label: (0, _capitalize.default)(trigger),
    id: trigger,
    checked: selectedTrigger === trigger,
    onChange: () => {},
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: (0, _react2.css)`
                    text-wrap: auto;
                    margin-left: ${euiTheme.size.l};
                  `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 17
    }
  }, _translations.MANUAL_TRIGGERS_DESCRIPTIONS[trigger]))))), selectedTrigger === 'alert' && /*#__PURE__*/_react.default.createElement(_workflow_execute_event_form.WorkflowExecuteEventForm, {
    value: executionInput,
    setValue: setExecutionInput,
    errors: executionInputErrors,
    setErrors: setExecutionInputErrors,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 11
    }
  }), selectedTrigger === 'manual' && /*#__PURE__*/_react.default.createElement(_workflow_execute_manual_form.WorkflowExecuteManualForm, {
    definition: definition,
    value: executionInput,
    errors: executionInputErrors,
    setErrors: setExecutionInputErrors,
    setValue: setExecutionInput,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: handleSubmit,
    iconType: "play",
    disabled: Boolean(executionInputErrors),
    color: "success",
    "data-test-subj": "executeWorkflowButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "keepWorkflows.buttonText",
    defaultMessage: "Run",
    ignoreTag: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }))));
}