"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecutionGraphNode = ExecutionGraphNode;
var _eui = require("@elastic/eui");
var _workflows = require("@kbn/workflows");
var _react = require("@xyflow/react");
var _react2 = _interopRequireDefault(require("react"));
var _types = require("./types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/debug-graph/nodes/execution_graph_node.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const getNodeBorderColor = (status, euiTheme) => {
  if (!status) {
    return 'transparent';
  }
  switch (status) {
    case _workflows.ExecutionStatus.FAILED:
      return euiTheme.colors.danger;
    case _workflows.ExecutionStatus.COMPLETED:
      return '#16C5C0';
    case _workflows.ExecutionStatus.PENDING:
      return euiTheme.colors.borderBaseNeutral;
    case _workflows.ExecutionStatus.RUNNING:
      return euiTheme.colors.borderBaseNeutral;
    case _workflows.ExecutionStatus.CANCELLED:
      return euiTheme.colors.borderBaseNeutral;
    case _workflows.ExecutionStatus.SKIPPED:
      return euiTheme.colors.borderBaseNeutral;
    case _workflows.ExecutionStatus.WAITING_FOR_INPUT:
      return euiTheme.colors.borderBaseNeutral;
    default:
      return 'transparent';
  }
};
const getNodeBackgroundColor = (nodeType, euiTheme) => {
  if (_types.mainScopeNodes.includes(nodeType)) {
    return {
      backgroundColor: euiTheme.colors.backgroundBaseWarning,
      color: euiTheme.colors.warning
    };
  }
  if (_types.secondaryScopeNodes.includes(nodeType)) {
    return {
      backgroundColor: euiTheme.colors.backgroundBaseSuccess,
      color: euiTheme.colors.success
    };
  }
  if (_types.atomicNodes.includes(nodeType)) {
    return {
      backgroundColor: euiTheme.colors.backgroundBasePrimary,
      color: euiTheme.colors.primary
    };
  }
  return {
    backgroundColor: euiTheme.colors.backgroundBasePrimary,
    color: euiTheme.colors.primary
  };
};
function ExecutionGraphNode(node) {
  var _node$data$stepExecut, _node$data$stepExecut2, _node$data$stepExecut3;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: {
      width: '100%',
      height: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_react.Handle, {
    type: "target",
    position: _react.Position.Top,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: {
      width: '100%',
      height: '100%',
      backgroundColor: getNodeBackgroundColor(node.data.stepType, euiTheme).backgroundColor,
      borderRadius: '8px',
      padding: '8px 12px',
      boxShadow: '0px 2px 8px 0px rgba(43,57,79,0.05), 0px 1px 4px 0px rgba(43,57,79,0.06), 0px 0px 2px 0px rgba(43,57,79,0.16)',
      display: 'flex',
      alignItems: 'center',
      gap: '12px',
      border: `1px solid ${getNodeBorderColor((_node$data$stepExecut = node.data.stepExecution) === null || _node$data$stepExecut === void 0 ? void 0 : _node$data$stepExecut.status, euiTheme)}`
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: {
      flex: 1,
      width: '100%'
    },
    alignItems: "center",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: {
      flex: 1
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    direction: "column",
    css: {
      gap: '4px',
      flex: 1,
      width: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: {
      width: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement("span", {
    css: {
      fontSize: '14px',
      fontWeight: 'bold',
      color: euiTheme.colors.textHeading,
      lineHeight: '1.25',
      display: 'flex',
      alignItems: 'center',
      gap: '4px',
      justifyContent: 'space-between'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement("span", {
    title: node.data.label,
    css: {
      whiteSpace: 'nowrap',
      overflow: 'hidden',
      textOverflow: 'ellipsis',
      maxWidth: '160px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 19
    }
  }, node.data.label), ((_node$data$stepExecut2 = node.data.stepExecution) === null || _node$data$stepExecut2 === void 0 ? void 0 : _node$data$stepExecut2.status) === _workflows.ExecutionStatus.COMPLETED && /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: "checkInCircleFilled",
    color: "#16C5C0",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 21
    }
  }), ((_node$data$stepExecut3 = node.data.stepExecution) === null || _node$data$stepExecut3 === void 0 ? void 0 : _node$data$stepExecut3.status) === _workflows.ExecutionStatus.FAILED && /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: "alert",
    color: euiTheme.colors.danger,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react2.default.createElement("div", {
    css: {
      fontSize: '12px',
      color: euiTheme.colors.textSubdued
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 17
    }
  }, node.data.stepType)))))), /*#__PURE__*/_react2.default.createElement(_react.Handle, {
    type: "source",
    position: _react.Position.Bottom,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 7
    }
  }));
}