"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecutionGraph = void 0;
var _react = _interopRequireWildcard(require("react"));
var _graph = require("@kbn/workflows/graph");
var _react2 = require("@xyflow/react");
var _eui = require("@elastic/eui");
var _schema = require("../../../common/schema");
var _yaml_utils = require("../../../common/lib/yaml_utils");
var _nodes = require("./nodes");
var _workflow_graph_layout = require("./workflow_graph_layout");
var _types = require("./nodes/types");
require("@xyflow/react/dist/style.css");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/debug-graph/execution_graph.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const nodeTypes = [..._types.mainScopeNodes, ..._types.secondaryScopeNodes, ..._types.atomicNodes].reduce((acc, nodeType) => {
  acc[nodeType] = _nodes.ExecutionGraphNode;
  return acc;
}, {});
const edgeTypes = {
  default: _nodes.ExecutionGraphEdge,
  workflowEdge: _nodes.ExecutionGraphEdge
};

// Wrapper component to handle ReactFlow initialization timing
const ReactFlowWrapper = ({
  nodes,
  edges,
  nodeTypesMap,
  edgeTypesMap
}) => {
  const [isReady, setIsReady] = _react.default.useState(false);

  // Use a small delay to ensure ReactFlow is properly initialized
  _react.default.useEffect(() => {
    const timer = setTimeout(() => {
      setIsReady(true);
    }, 50); // Small delay to ensure proper initialization

    return () => clearTimeout(timer);
  }, [nodes, edges]);
  const onInit = _react.default.useCallback(reactFlowInstance => {
    // Fit view once the instance is ready
    setTimeout(() => {
      reactFlowInstance.fitView({
        padding: 0.1
      });
    }, 100);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react2.ReactFlow, {
    nodes: nodes,
    edges: edges,
    nodeTypes: nodeTypesMap,
    edgeTypes: edgeTypesMap,
    onInit: onInit,
    fitView: isReady,
    fitViewOptions: {
      padding: 0.1
    },
    proOptions: {
      hideAttribution: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react2.Background, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_react2.Controls, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }));
};
const ExecutionGraph = ({
  workflowYaml
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [debouncedWorkflowYaml, setDebouncedWorkflowYaml] = _react.default.useState(workflowYaml);
  (0, _react.useEffect)(() => {
    const handler = setTimeout(() => {
      setDebouncedWorkflowYaml(workflowYaml);
    }, 500);
    return () => {
      clearTimeout(handler);
    };
  }, [workflowYaml]);
  const workflowExecutionGraph = (0, _react.useMemo)(() => {
    if (!debouncedWorkflowYaml) {
      return null;
    }
    let result = null;
    let error = null;
    try {
      const parsingResult = (0, _yaml_utils.parseWorkflowYamlToJSON)(debouncedWorkflowYaml, (0, _schema.getWorkflowZodSchemaLoose)());
      if (parsingResult.error) {
        error = parsingResult.error;
      }
      result = (0, _graph.convertToWorkflowGraph)(parsingResult.data);
    } catch (e) {
      error = e;
    }
    return {
      result,
      error
    };
  }, [debouncedWorkflowYaml]);
  const layoutResult = (0, _react.useMemo)(() => {
    if (!workflowExecutionGraph) {
      return null;
    }
    if (workflowExecutionGraph.error) {
      return {
        result: null,
        error: workflowExecutionGraph.error
      };
    }
    let result = null;
    let error = null;
    try {
      result = (0, _workflow_graph_layout.convertWorkflowGraphToReactFlow)(workflowExecutionGraph.result);
    } catch (e) {
      error = e.message;
    }
    return {
      result,
      error
    };
  }, [workflowExecutionGraph]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (layoutResult === null || layoutResult === void 0 ? void 0 : layoutResult.error) && /*#__PURE__*/_react.default.createElement("div", {
    style: {
      color: euiTheme.colors.danger
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }, "Error generating graph layout: ", String(layoutResult.error)), (layoutResult === null || layoutResult === void 0 ? void 0 : layoutResult.result) && /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '100%',
      height: '100%',
      border: `1px solid ${euiTheme.border.color}`,
      position: 'relative'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      position: 'absolute',
      bottom: 10,
      left: 10,
      backgroundColor: euiTheme.colors.emptyShade,
      padding: 5,
      zIndex: 10
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  }, "Nodes: ", layoutResult.result.nodes.length, ", Edges: ", layoutResult.result.edges.length), /*#__PURE__*/_react.default.createElement(ReactFlowWrapper, {
    nodes: layoutResult.result.nodes,
    edges: layoutResult.result.edges,
    nodeTypesMap: nodeTypes,
    edgeTypesMap: edgeTypes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  })), !layoutResult && /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'flex',
      justifyContent: 'center',
      alignItems: 'center',
      height: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 9
    }
  }, "No valid workflow graph to display!"));
};
exports.ExecutionGraph = ExecutionGraph;