"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsMenu = ActionsMenu;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _get_action_options = require("../lib/get_action_options");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/actions_menu_popover/ui/actions_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ActionsMenu({
  onActionSelected
}) {
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const [searchTerm, setSearchTerm] = (0, _react.useState)('');
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const defaultOptions = (0, _react.useMemo)(() => (0, _get_action_options.getActionOptions)(euiTheme), [euiTheme]);
  const flatOptions = (0, _react.useMemo)(() => (0, _get_action_options.flattenOptions)(defaultOptions), [defaultOptions]);
  const [options, setOptions] = (0, _react.useState)(defaultOptions);
  const [currentPath, setCurrentPath] = (0, _react.useState)([]);
  const renderActionOption = (option, searchValue) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      css: styles.actionOption,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: [styles.iconOuter, option.options ? styles.groupIconOuter : styles.actionIconOuter],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      css: option.options ? styles.groupIconInner : styles.actionIconInner,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: option.iconType,
      size: "m",
      color: option === null || option === void 0 ? void 0 : option.iconColor,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxxs",
      css: styles.actionTitle,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h6", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchValue,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 17
      }
    }, option.label)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      className: "eui-displayBlock",
      css: styles.actionDescription,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchValue,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 15
      }
    }, option.description || '')))));
  };
  const handleChange = (_, __, selectedOption) => {
    if (selectedOption !== null && selectedOption !== void 0 && selectedOption.options) {
      setCurrentPath([...currentPath, selectedOption.id]);
      setSearchTerm('');
      setOptions(selectedOption.options);
    } else {
      onActionSelected(selectedOption);
    }
  };
  const handleBack = () => {
    const nextPath = currentPath.slice(0, -1);
    let nextOptions = defaultOptions;
    for (const id of nextPath) {
      var _nextOptions$find;
      nextOptions = ((_nextOptions$find = nextOptions.find(option => option.id === id)) === null || _nextOptions$find === void 0 ? void 0 : _nextOptions$find.options) || [];
    }
    setCurrentPath(nextPath);
    setOptions(nextOptions);
  };
  const optionMatcher = ({
    option,
    searchValue,
    normalizedSearchValue
  }) => {
    var _option$description;
    return option.id.toLowerCase().includes(normalizedSearchValue) || option.label.toLowerCase().includes(normalizedSearchValue) || !!((_option$description = option.description) !== null && _option$description !== void 0 && _option$description.toLowerCase().includes(normalizedSearchValue));
  };
  const handleSearchChange = searchValue => {
    setSearchTerm(searchValue);
    if (searchValue.length > 0) {
      const term = searchValue.trim().toLowerCase();
      const matches = flatOptions.filter(option => optionMatcher({
        option,
        searchValue,
        normalizedSearchValue: term
      }));
      setOptions(matches);
    } else {
      setOptions(defaultOptions);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": "Selectable example with custom list items",
    searchable: true,
    options: options,
    onChange: handleChange,
    optionMatcher: optionMatcher,
    searchProps: {
      id: 'actions-menu-search',
      name: 'actions-menu-search',
      value: searchTerm,
      onChange: handleSearchChange
    },
    listProps: {
      rowHeight: 64,
      showIcons: false
    },
    renderOption: renderActionOption,
    css: styles.selectable,
    singleSelection: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 5
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    css: styles.header,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.title,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 15
    }
  }, currentPath.length === 0 ? /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "workflows.actionsMenu.selectAction",
    defaultMessage: "Select an action",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 21
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: handleBack,
    iconType: "arrowLeft",
    size: "xs",
    "aria-label": _i18n.i18n.translate('workflows.actionsMenu.back', {
      defaultMessage: 'Back'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "workflows.actionsMenu.back",
    defaultMessage: "Back",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 21
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 13
    }
  }, search)), list));
}
const componentStyles = {
  selectable: ({
    euiTheme
  }) => (0, _react2.css)({
    backgroundColor: euiTheme.colors.backgroundBasePlain,
    '& .euiSelectableListItem': {
      paddingBlock: euiTheme.size.m,
      paddingInline: '16px'
    }
  }),
  title: (0, _react2.css)({
    display: 'flex',
    alignItems: 'flex-start',
    // to avoid layout shift when the header is button
    minHeight: '24px'
  }),
  header: ({
    euiTheme
  }) => (0, _react2.css)({
    padding: euiTheme.size.m
  }),
  actionOption: (0, _react2.css)({
    gap: '12px'
  }),
  iconOuter: (0, _react2.css)({
    width: '40px',
    height: '40px',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    flexShrink: 0
  }),
  groupIconOuter: ({
    euiTheme
  }) => (0, _react2.css)({
    border: `1px solid ${euiTheme.colors.borderBasePlain}`,
    borderRadius: euiTheme.border.radius.medium
  }),
  actionIconOuter: ({
    euiTheme
  }) => (0, _react2.css)({
    backgroundColor: euiTheme.colors.backgroundBaseSubdued,
    borderRadius: '100%'
  }),
  groupIconInner: ({
    euiTheme
  }) => (0, _react2.css)({}),
  actionIconInner: ({
    euiTheme
  }) => (0, _react2.css)({
    width: '24px',
    height: '24px',
    borderRadius: '100%',
    backgroundColor: euiTheme.colors.backgroundBasePlain,
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center'
  }),
  actionTitle: euiThemeContext => (0, _react2.css)({
    lineHeight: (0, _eui.euiFontSize)(euiThemeContext, 's').lineHeight,
    '&::first-letter': {
      textTransform: 'capitalize'
    }
  }),
  actionDescription: euiThemeContext => (0, _react2.css)({
    lineHeight: (0, _eui.euiFontSize)(euiThemeContext, 's').lineHeight
  })
};