"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWorkflows = useWorkflows;
var _reactQuery = require("@kbn/react-query");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function useWorkflows(params) {
  const {
    http
  } = (0, _public.useKibana)().services;
  return (0, _reactQuery.useQuery)({
    networkMode: 'always',
    queryKey: ['workflows', params],
    queryFn: () => {
      return http.post('/api/workflows/search', {
        body: JSON.stringify(params)
      });
    },
    keepPreviousData: true
  });
}