"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWorkflowDetail = useWorkflowDetail;
var _reactQuery = require("@kbn/react-query");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function useWorkflowDetail(id) {
  const {
    http
  } = (0, _public.useKibana)().services;
  return (0, _reactQuery.useQuery)({
    networkMode: 'always',
    enabled: !!id,
    queryKey: ['workflows', id],
    queryFn: () => {
      return http.get(`/api/workflows/${id}`).then(res => {
        return {
          ...res,
          lastUpdatedAt: new Date(res.lastUpdatedAt)
        };
      });
    }
  });
}