"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WORKFLOW_ID_REQUIRED = exports.WORKFLOW_ID_LABEL = exports.WORKFLOW_DISABLED_WARNING = exports.SELECT_WORKFLOW_PLACEHOLDER = exports.SELECTED_WORKFLOW_DISABLED_ERROR = exports.OPEN_WORKFLOW_LINK = exports.NO_WORKFLOWS_AVAILABLE = exports.NO_CONFIGURATION_REQUIRED = exports.LOADING_WORKFLOWS = exports.FILTER_WORKFLOWS_PLACEHOLDER = exports.FAILED_TO_LOAD_WORKFLOWS = exports.DISABLED_BADGE_LABEL = exports.CREATE_NEW_WORKFLOW = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const NO_CONFIGURATION_REQUIRED = exports.NO_CONFIGURATION_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.workflows.noConfigurationRequired', {
  defaultMessage: 'No configuration required. This connector uses the internal Kibana workflows API.'
});
const WORKFLOW_ID_LABEL = exports.WORKFLOW_ID_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.workflows.workflowIdTextFieldLabel', {
  defaultMessage: 'Select Workflow'
});
const WORKFLOW_ID_REQUIRED = exports.WORKFLOW_ID_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.workflows.error.requiredWorkflowIdText', {
  defaultMessage: 'Workflow ID is required.'
});
const SELECT_WORKFLOW_PLACEHOLDER = exports.SELECT_WORKFLOW_PLACEHOLDER = _i18n.i18n.translate('xpack.stackConnectors.components.workflows.selectWorkflowPlaceholder', {
  defaultMessage: 'Select a workflow'
});
const LOADING_WORKFLOWS = exports.LOADING_WORKFLOWS = _i18n.i18n.translate('xpack.stackConnectors.components.workflows.loadingWorkflows', {
  defaultMessage: 'Loading workflows...'
});
const NO_WORKFLOWS_AVAILABLE = exports.NO_WORKFLOWS_AVAILABLE = _i18n.i18n.translate('xpack.stackConnectors.components.workflows.noWorkflowsAvailable', {
  defaultMessage: 'No workflows available'
});
const FAILED_TO_LOAD_WORKFLOWS = exports.FAILED_TO_LOAD_WORKFLOWS = _i18n.i18n.translate('xpack.stackConnectors.components.workflows.failedToLoadWorkflows', {
  defaultMessage: 'Failed to load workflows. Please check your connector configuration.'
});
const CREATE_NEW_WORKFLOW = exports.CREATE_NEW_WORKFLOW = _i18n.i18n.translate('xpack.stackConnectors.components.workflows.createNewWorkflow', {
  defaultMessage: 'Create new'
});
const FILTER_WORKFLOWS_PLACEHOLDER = exports.FILTER_WORKFLOWS_PLACEHOLDER = _i18n.i18n.translate('xpack.stackConnectors.components.workflows.filterWorkflowsPlaceholder', {
  defaultMessage: 'Filter workflows'
});
const WORKFLOW_DISABLED_WARNING = exports.WORKFLOW_DISABLED_WARNING = _i18n.i18n.translate('xpack.stackConnectors.components.workflows.workflowDisabledWarning', {
  defaultMessage: 'This workflow is currently disabled'
});
const DISABLED_BADGE_LABEL = exports.DISABLED_BADGE_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.workflows.disabledBadgeLabel', {
  defaultMessage: 'Disabled'
});
const SELECTED_WORKFLOW_DISABLED_ERROR = exports.SELECTED_WORKFLOW_DISABLED_ERROR = _i18n.i18n.translate('xpack.stackConnectors.components.workflows.selectedWorkflowDisabledError', {
  defaultMessage: 'The previously selected workflow is no longer available. Please select a different workflow.'
});
const OPEN_WORKFLOW_LINK = exports.OPEN_WORKFLOW_LINK = _i18n.i18n.translate('xpack.stackConnectors.components.workflows.openWorkflowLink', {
  defaultMessage: 'Open workflow'
});