"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRIGGERS_LIST_TITLE = exports.SEARCH_WORKFLOWS = exports.SEARCH_PLACEHOLDER = exports.MANUAL_TRIGGERS_DESCRIPTIONS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const SEARCH_WORKFLOWS = exports.SEARCH_WORKFLOWS = _i18n.i18n.translate('xpack.workflowsManagement.workflowsList.searchAriaLabel', {
  defaultMessage: 'Search workflows'
});
const SEARCH_PLACEHOLDER = exports.SEARCH_PLACEHOLDER = _i18n.i18n.translate('plugins.workflowsManagement.workflowsList.searchPlaceholder', {
  defaultMessage: 'Workflow name/description'
});
const MANUAL_TRIGGERS_DESCRIPTIONS = exports.MANUAL_TRIGGERS_DESCRIPTIONS = {
  manual: _i18n.i18n.translate('plugins.workflowsManagement.workflowsExecution.manualTriggerDescription', {
    defaultMessage: 'Provide custom JSON data manually for testing. Ideal for simulating specific scenarios or debugging edge cases.'
  }),
  alert: _i18n.i18n.translate('plugins.workflowsManagement.workflowsExecution.alertTriggerDescription', {
    defaultMessage: 'Choose a document directly from an index to use as the test input. This is helpful for verifying workflows against real indexed data.'
  }),
  scheduled: _i18n.i18n.translate('plugins.workflowsManagement.workflowsExecution.scheduledTriggerDescription', {
    defaultMessage: 'Select a schedule to trigger workflow'
  })
};
const TRIGGERS_LIST_TITLE = exports.TRIGGERS_LIST_TITLE = _i18n.i18n.translate('plugins.workflowsManagement.workflowsList.triggersListTitle', {
  defaultMessage: 'Triggers'
});