"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowTaskManager = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class WorkflowTaskManager {
  constructor(taskManager) {
    this.taskManager = taskManager;
  }
  async scheduleResumeTask({
    runAt,
    workflowRunId,
    spaceId
  }) {
    const task = await this.taskManager.schedule({
      taskType: 'workflow:resume',
      params: {
        workflowRunId,
        spaceId
      },
      state: {},
      runAt
    });
    return {
      taskId: task.id
    };
  }
}
exports.WorkflowTaskManager = WorkflowTaskManager;