"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterStepTimeoutZoneNodeImpl = void 0;
var _utils = require("../../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class EnterStepTimeoutZoneNodeImpl {
  constructor(node, wfExecutionRuntimeManager, wfExecutionState, stepContext) {
    this.node = node;
    this.wfExecutionRuntimeManager = wfExecutionRuntimeManager;
    this.wfExecutionState = wfExecutionState;
    this.stepContext = stepContext;
  }
  async run() {
    await this.wfExecutionRuntimeManager.startStep();
    this.wfExecutionRuntimeManager.enterScope();
    this.wfExecutionRuntimeManager.navigateToNextNode();
  }
  monitor(monitoredContext) {
    const timeoutMs = (0, _utils.parseDuration)(this.node.timeout);
    const stepExecution = this.wfExecutionState.getStepExecution(this.stepContext.stepExecutionId);
    const whenStepStartedTime = new Date(stepExecution.startedAt).getTime();
    const currentTimeMs = new Date().getTime();
    const currentStepDuration = currentTimeMs - whenStepStartedTime;
    if (currentStepDuration > timeoutMs) {
      monitoredContext.abortController.abort();
      throw new Error(`TimeoutError: Step execution exceeded the configured timeout of ${this.node.timeout}.`);
    }
    return Promise.resolve();
  }
}
exports.EnterStepTimeoutZoneNodeImpl = EnterStepTimeoutZoneNodeImpl;