"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorStepImpl = void 0;
var _node_implementation = require("./node_implementation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Extend BaseStep for connector-specific properties

class ConnectorStepImpl extends _node_implementation.BaseAtomicNodeImplementation {
  constructor(step, contextManager, connectorExecutor, workflowState, workflowLogger) {
    super(step, contextManager, connectorExecutor, workflowState);
    this.workflowLogger = workflowLogger;
  }
  getInput() {
    var _this$step$with;
    // Get current context for templating
    const context = this.contextManager.getContext();
    // Render inputs from 'with'
    return Object.entries((_this$step$with = this.step.with) !== null && _this$step$with !== void 0 ? _this$step$with : {}).reduce((acc, [key, value]) => {
      if (typeof value === 'string') {
        acc[key] = this.templatingEngine.render(value, context);
      } else {
        acc[key] = value;
      }
      return acc;
    }, {});
  }
  async _run(withInputs) {
    try {
      const step = this.step;

      // Parse step type and determine if it's a sub-action
      const [stepType, subActionName] = step.type.includes('.') ? step.type.split('.', 2) : [step.type, null];
      const isSubAction = subActionName !== null;

      // TODO: remove this once we have a proper connector executor/step for console
      if (step.type === 'console.log' || step.type === 'console') {
        this.workflowLogger.logInfo(`Log from step ${step.name}: \n${withInputs.message}`, {
          workflow: {
            step_id: step.name
          },
          event: {
            action: 'log',
            outcome: 'success'
          },
          tags: ['console', 'log']
        });
        // eslint-disable-next-line no-console
        console.log(withInputs.message);
        return {
          input: withInputs,
          output: withInputs.message,
          error: undefined
        };
      } else if (step.type === 'delay') {
        var _step$with$delay, _step$with;
        const delayTime = (_step$with$delay = (_step$with = step.with) === null || _step$with === void 0 ? void 0 : _step$with.delay) !== null && _step$with$delay !== void 0 ? _step$with$delay : 1000;
        // this.contextManager.logDebug(`Delaying for ${delayTime}ms`);
        await new Promise(resolve => setTimeout(resolve, delayTime));
        return {
          input: withInputs,
          output: `Delayed for ${delayTime}ms`,
          error: undefined
        };
      }

      // Build final rendered inputs
      const renderedInputs = isSubAction ? {
        subActionParams: withInputs,
        subAction: subActionName
      } : withInputs;
      const output = await this.connectorExecutor.execute(stepType, step['connector-id'], renderedInputs, step.spaceId);
      const {
        data,
        status,
        message
      } = output;
      if (status === 'ok') {
        return {
          input: withInputs,
          output: data,
          error: undefined
        };
      } else {
        return await this.handleFailure(withInputs, message);
      }
    } catch (error) {
      return await this.handleFailure(withInputs, error);
    }
  }
}
exports.ConnectorStepImpl = ConnectorStepImpl;