"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThresholdWatchEdit = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../common/constants");
var _serialization = require("../../../../../../common/lib/serialization");
var _components = require("../../../../components");
var _api = require("../../../../lib/api");
var _agg_types = require("../../../../models/watch/agg_types");
var _group_by_types = require("../../../../models/watch/group_by_types");
var _comparators = require("../../../../models/watch/comparators");
var _watch_edit_actions = require("../../watch_edit_actions");
var _watch_context = require("../../watch_context");
var _watch_visualization = require("./watch_visualization");
var _threshold_watch_action_panel = require("./threshold_watch_action_panel");
var _get_time_unit_label = require("../../../../lib/get_time_unit_label");
var _navigation = require("../../../../lib/navigation");
var _request_flyout = require("../request_flyout");
var _app_context = require("../../../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/watcher/public/application/sections/watch_edit_page/components/threshold_watch_edit/threshold_watch_edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const styles = {
  watcherThresholdAlertAggFieldContainer: (0, _react2.css)`
    width: 300px;
  `,
  watcherThresholdInBetweenComparatorText: (0, _react2.css)`
    align-self: center;
  `
};
const expressionFieldsWithValidation = ['aggField', 'termSize', 'termField', 'threshold0', 'threshold1', 'timeWindowSize'];
const expressionFields = ['aggType', 'aggField', 'termSize', 'termField', 'thresholdComparator', 'timeWindowSize', 'timeWindowUnit', 'triggerIntervalSize', 'triggerIntervalUnit', 'threshold', 'groupBy'];
const expressionErrorMessage = _i18n.i18n.translate('xpack.watcher.thresholdWatchExpression.fixErrorInExpressionBelowValidationMessage', {
  defaultMessage: 'Expression contains errors.'
});
const firstFieldOption = {
  text: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.titlePanel.timeFieldOptionLabel', {
    defaultMessage: 'Select a field'
  }),
  value: ''
};
const getTimeOptions = unitSize => Object.entries(_constants.TIME_UNITS).map(([_key, value]) => {
  return {
    text: (0, _get_time_unit_label.getTimeUnitLabel)(value, unitSize),
    value
  };
});
const getFields = async indices => {
  return await (0, _api.fetchFields)(indices);
};
const getTimeFieldOptions = fields => {
  const options = [firstFieldOption];
  fields.forEach(field => {
    if (field.type === 'date') {
      options.push({
        text: field.name,
        value: field.name
      });
    }
  });
  return options;
};
const getIndexOptions = async (patternString, indexPatterns) => {
  const options = [];
  if (!patternString) {
    return options;
  }
  const matchingIndices = await (0, _api.getMatchingIndices)(patternString);
  const matchingIndexPatterns = indexPatterns.filter(anIndexPattern => {
    return anIndexPattern.includes(patternString);
  });
  if (matchingIndices.length || matchingIndexPatterns.length) {
    const matchingOptions = _lodash.default.uniq([...matchingIndices, ...matchingIndexPatterns]);
    options.push({
      label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.titlePanel.indicesAndIndexPatternsLabel', {
        defaultMessage: 'Based on your indices and index patterns'
      }),
      options: matchingOptions.map(match => {
        return {
          label: match,
          value: match
        };
      }).sort((a, b) => String(a.label).localeCompare(b.label))
    });
  }
  options.push({
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.titlePanel.chooseLabel', {
      defaultMessage: 'Choose…'
    }),
    options: [{
      key: 'UNIQUE_CHOOSE_KEY',
      value: patternString,
      label: patternString
    }]
  });
  return options;
};
const ThresholdWatchEdit = ({
  pageTitle
}) => {
  // hooks
  const {
    toasts
  } = (0, _app_context.useAppContext)();
  const [indexPatterns, setIndexPatterns] = (0, _react.useState)([]);
  const [esFields, setEsFields] = (0, _react.useState)([]);
  const [indexOptions, setIndexOptions] = (0, _react.useState)([]);
  const [timeFieldOptions, setTimeFieldOptions] = (0, _react.useState)([firstFieldOption]);
  const [aggFieldPopoverOpen, setAggFieldPopoverOpen] = (0, _react.useState)(false);
  const [groupByPopoverOpen, setGroupByPopoverOpen] = (0, _react.useState)(false);
  const [watchThresholdPopoverOpen, setWatchThresholdPopoverOpen] = (0, _react.useState)(false);
  const [watchDurationPopoverOpen, setWatchDurationPopoverOpen] = (0, _react.useState)(false);
  const [aggTypePopoverOpen, setAggTypePopoverOpen] = (0, _react.useState)(false);
  const [serverError, setServerError] = (0, _react.useState)(null);
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [isIndiciesLoading, setIsIndiciesLoading] = (0, _react.useState)(false);
  const [isRequestVisible, setIsRequestVisible] = (0, _react.useState)(false);
  const {
    watch,
    setWatchProperty
  } = (0, _react.useContext)(_watch_context.WatchContext);
  (0, _react.useEffect)(() => {
    const getIndexPatterns = async () => {
      const {
        data: indexPatternTitles
      } = await (0, _api.loadIndexPatterns)();
      setIndexPatterns(indexPatternTitles);
    };
    const loadData = async () => {
      if (watch.index && watch.index.length > 0) {
        const allEsFields = await getFields(watch.index);
        const timeFields = getTimeFieldOptions(allEsFields);
        setEsFields(allEsFields);
        setTimeFieldOptions(timeFields);
        setWatchProperty('timeFields', timeFields);
      }
      getIndexPatterns();
    };
    loadData();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const {
    errors
  } = watch.validate();
  const hasErrors = !!Object.keys(errors).find(errorKey => errors[errorKey].length >= 1);
  const actionErrors = watch.actions.reduce((acc, action) => {
    const actionValidationErrors = action.validate();
    acc[action.id] = actionValidationErrors;
    return acc;
  }, {});
  const hasActionErrors = !!Object.keys(actionErrors).find(actionError => {
    return !!Object.keys(actionErrors[actionError]).find(actionErrorKey => {
      return actionErrors[actionError][actionErrorKey].length >= 1;
    });
  });
  const hasExpressionErrors = !!Object.keys(errors).find(errorKey => expressionFieldsWithValidation.includes(errorKey) && errors[errorKey].length >= 1);
  const shouldShowThresholdExpression = watch.index && watch.index.length > 0 && watch.timeField;
  const andThresholdText = _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.andLabel', {
    defaultMessage: 'AND'
  });
  const watchIntervalLabel = _i18n.i18n.translate('xpack.watcher.sections.watchEdit.titlePanel.watchIntervalLabel', {
    defaultMessage: 'Run watch every'
  });

  // Users might edit the request for use outside of the Watcher app. If they do make changes to it,
  // we have no guarantee it will still be compatible with the threshold alert form, so we strip
  // the metadata to avoid potential conflicts.
  const requestPreviewWatchData = {
    ...watch.upstreamJson,
    includeMetadata: false
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: true,
    style: {
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "pageTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 257,
        columnNumber: 20
      }
    }, pageTitle),
    description: watch.titleDescription,
    bottomBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": "thresholdWatchForm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 7
    }
  }, serverError && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_components.SectionError, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchEdit.json.saveWatchErrorTitle",
      defaultMessage: "Error saving watch",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 269,
        columnNumber: 17
      }
    }),
    error: serverError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_components.ErrableFormRow, {
    id: "watchName",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchEdit.titlePanel.watchNameLabel",
      defaultMessage: "Name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 282,
        columnNumber: 13
      }
    }),
    errorKey: "name",
    isShowingErrors: hasErrors && watch.name !== undefined,
    errors: errors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "name",
    "data-test-subj": "nameInput",
    value: watch.name || '',
    onChange: e => {
      setWatchProperty('name', e.target.value);
    },
    onBlur: () => {
      if (!watch.name) {
        setWatchProperty('name', '');
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_components.ErrableFormRow, {
    id: "indexSelectSearchBox",
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchEdit.titlePanel.indicesToQueryLabel",
      defaultMessage: "Indices to query",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 312,
        columnNumber: 17
      }
    }),
    errorKey: "index",
    isShowingErrors: hasErrors && watch.index !== undefined,
    errors: errors,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchEdit.titlePanel.howToBroadenSearchQueryDescription",
      defaultMessage: "Use * to broaden your query.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 321,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    async: true,
    isLoading: isIndiciesLoading,
    noSuggestions: !indexOptions.length,
    options: indexOptions,
    "data-test-subj": "indicesComboBox",
    selectedOptions: (watch.index || []).map(anIndex => {
      return {
        label: anIndex,
        value: anIndex
      };
    }),
    onChange: async selected => {
      setWatchProperty('index', selected.map(aSelected => aSelected.value));
      const indices = selected.map(s => s.value);

      // reset time field and expression fields if indices are deleted
      if (indices.length === 0) {
        setTimeFieldOptions(getTimeFieldOptions([]));
        setWatchProperty('timeFields', []);
        expressionFields.forEach(expressionField => {
          setWatchProperty(expressionField, null);
        });
        return;
      }
      const currentEsFields = await getFields(indices);
      const timeFields = getTimeFieldOptions(currentEsFields);
      setEsFields(currentEsFields);
      setWatchProperty('timeFields', timeFields);
      setTimeFieldOptions(timeFields);
    },
    onSearchChange: async search => {
      setIsIndiciesLoading(true);
      setIndexOptions(await getIndexOptions(search, indexPatterns));
      setIsIndiciesLoading(false);
    },
    onBlur: () => {
      if (!watch.index) {
        setWatchProperty('index', []);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 327,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 377,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_components.ErrableFormRow, {
    id: "timeField",
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchEdit.titlePanel.timeFieldLabel",
      defaultMessage: "Time field",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 382,
        columnNumber: 17
      }
    }),
    errorKey: "timeField",
    isShowingErrors: hasErrors && watch.timeField !== undefined,
    errors: errors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 378,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: timeFieldOptions,
    fullWidth: true,
    name: "watchTimeField",
    "data-test-subj": "watchTimeFieldSelect",
    value: watch.timeField,
    onChange: e => {
      setWatchProperty('timeField', e.target.value);
    },
    onBlur: () => {
      if (watch.timeField === undefined) {
        setWatchProperty('timeField', '');
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 391,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 408,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_components.ErrableFormRow, {
    id: "watchInterval",
    fullWidth: true,
    label: watchIntervalLabel,
    errorKey: "triggerIntervalSize",
    isShowingErrors: hasErrors && watch.triggerIntervalSize !== undefined,
    errors: errors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 409,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 417,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 418,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    min: 1,
    value: watch.triggerIntervalSize,
    "data-test-subj": "triggerIntervalSizeInput",
    onChange: e => {
      const {
        value
      } = e.target;
      const triggerIntervalSize = value !== '' ? parseInt(value, 10) : value;
      setWatchProperty('triggerIntervalSize', triggerIntervalSize);
    },
    onBlur: e => {
      if (watch.triggerIntervalSize === undefined) {
        setWatchProperty('triggerIntervalSize', '');
      }
    },
    "aria-label": watchIntervalLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 419,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 437,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    value: watch.triggerIntervalUnit,
    "aria-label": _i18n.i18n.translate('xpack.watcher.sections.watchEdit.titlePanel.durationAriaLabel', {
      defaultMessage: 'Duration time unit'
    }),
    onChange: e => {
      setWatchProperty('triggerIntervalUnit', e.target.value);
    },
    options: getTimeOptions(watch.triggerIntervalSize),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 438,
      columnNumber: 19
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 457,
      columnNumber: 9
    }
  }), shouldShowThresholdExpression ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 459,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 460,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "watchConditionTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 461,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.sections.watchEdit.watchConditionSectionTitle",
    defaultMessage: "Match the following condition",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 462,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 468,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 469,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 470,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "aggTypePopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.whenLabel', {
        defaultMessage: 'when'
      }),
      value: _agg_types.aggTypes[watch.aggType].text,
      isActive: aggTypePopoverOpen,
      onClick: () => {
        setAggTypePopoverOpen(true);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 474,
        columnNumber: 21
      }
    }),
    isOpen: aggTypePopoverOpen,
    closePopover: () => {
      setAggTypePopoverOpen(false);
    },
    ownFocus: true,
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 471,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 495,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 496,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.whenButtonLabel', {
    defaultMessage: 'when'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    value: watch.aggType,
    "aria-label": _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.aggTypeSelectAriaLabel', {
      defaultMessage: 'Aggregation type'
    }),
    onChange: e => {
      setWatchProperty('aggType', e.target.value);
      setAggTypePopoverOpen(false);
    },
    options: Object.values(_agg_types.aggTypes).map(({
      text,
      value
    }) => {
      return {
        text,
        value
      };
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 504,
      columnNumber: 21
    }
  })))), watch.aggType && _agg_types.aggTypes[watch.aggType].fieldRequired ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 527,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "aggFieldPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.ofLabel', {
        defaultMessage: 'of'
      }),
      value: watch.aggField || firstFieldOption.text,
      isActive: aggFieldPopoverOpen || !watch.aggField,
      onClick: () => {
        setAggFieldPopoverOpen(true);
      },
      color: watch.aggField ? 'success' : 'danger',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 531,
        columnNumber: 23
      }
    }),
    isOpen: aggFieldPopoverOpen,
    closePopover: () => {
      setAggFieldPopoverOpen(false);
    },
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 528,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 552,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 553,
      columnNumber: 23
    }
  }, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.ofButtonLabel', {
    defaultMessage: 'of'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 561,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: styles.watcherThresholdAlertAggFieldContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 562,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_components.ErrableFormRow, {
    errorKey: "aggField",
    isShowingErrors: hasErrors && watch.aggField !== undefined,
    errors: errors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 566,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    singleSelection: {
      asPlainText: true
    },
    placeholder: firstFieldOption.text,
    options: esFields.reduce((esFieldOptions, field) => {
      if (_agg_types.aggTypes[watch.aggType].validNormalizedTypes.includes(field.normalizedType)) {
        esFieldOptions.push({
          label: field.name
        });
      }
      return esFieldOptions;
    }, []),
    selectedOptions: watch.aggField ? [{
      label: watch.aggField
    }] : [],
    onChange: selectedOptions => {
      setWatchProperty('aggField', selectedOptions.length === 1 ? selectedOptions[0].label : undefined);
      setAggFieldPopoverOpen(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 571,
      columnNumber: 29
    }
  }))))))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 604,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "groupByPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: `${_group_by_types.groupByTypes[watch.groupBy].sizeRequired ? _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.groupedOverLabel', {
        defaultMessage: 'grouped over'
      }) : _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.overLabel', {
        defaultMessage: 'over'
      })}`,
      value: `${_group_by_types.groupByTypes[watch.groupBy].text} ${_group_by_types.groupByTypes[watch.groupBy].sizeRequired ? `${watch.termSize || ''} ${watch.termField ? `'${watch.termField}'` : ''}` : ''}`,
      isActive: groupByPopoverOpen || watch.groupBy === 'top' && !(watch.termSize && watch.termField),
      onClick: () => {
        setGroupByPopoverOpen(true);
      },
      color: watch.groupBy === 'all' || watch.termSize && watch.termField ? 'success' : 'danger',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 608,
        columnNumber: 21
      }
    }),
    isOpen: groupByPopoverOpen,
    closePopover: () => {
      setGroupByPopoverOpen(false);
    },
    ownFocus: true,
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 605,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 649,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 650,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.overButtonLabel', {
    defaultMessage: 'over'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 658,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 659,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    value: watch.groupBy,
    "aria-label": _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.groupBySelectAriaLabel', {
      defaultMessage: 'Group by'
    }),
    onChange: e => {
      setWatchProperty('termSize', null);
      setWatchProperty('termField', null);
      setWatchProperty('groupBy', e.target.value);
    },
    options: Object.values(_group_by_types.groupByTypes).map(({
      text,
      value
    }) => {
      return {
        text,
        value
      };
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 660,
      columnNumber: 25
    }
  })), _group_by_types.groupByTypes[watch.groupBy].sizeRequired ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 683,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 684,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_components.ErrableFormRow, {
    errorKey: "termSize",
    isShowingErrors: hasErrors,
    errors: errors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 685,
      columnNumber: 29
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: watch.termSize,
    onChange: e => {
      setWatchProperty('termSize', e.target.value);
    },
    min: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 690,
      columnNumber: 31
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 699,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_components.ErrableFormRow, {
    errorKey: "termField",
    isShowingErrors: hasErrors && watch.termField !== undefined,
    errors: errors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 700,
      columnNumber: 29
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    value: watch.termField || '',
    onChange: e => {
      setWatchProperty('termField', e.target.value);
    },
    options: esFields.reduce((options, field) => {
      if (_group_by_types.groupByTypes[watch.groupBy].validNormalizedTypes.includes(field.normalizedType)) {
        options.push({
          text: field.name,
          value: field.name
        });
      }
      return options;
    }, [firstFieldOption]),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 705,
      columnNumber: 31
    }
  })))) : null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 735,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "watchThresholdPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      "data-test-subj": "watchThresholdButton",
      description: _comparators.comparators[watch.thresholdComparator].text,
      value: watch.threshold.slice(0, _comparators.comparators[watch.thresholdComparator].requiredValues).join(` ${andThresholdText} `),
      isActive: Boolean(watchThresholdPopoverOpen || errors.threshold0.length || errors.threshold1 && errors.threshold1.length),
      onClick: () => {
        setWatchThresholdPopoverOpen(true);
      },
      color: errors.threshold0.length || errors.threshold1 && errors.threshold1.length ? 'danger' : 'success',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 739,
        columnNumber: 21
      }
    }),
    isOpen: watchThresholdPopoverOpen,
    closePopover: () => {
      setWatchThresholdPopoverOpen(false);
    },
    ownFocus: true,
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 736,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 767,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 768,
      columnNumber: 21
    }
  }, _comparators.comparators[watch.thresholdComparator].text), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 769,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 770,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    value: watch.thresholdComparator,
    "aria-label": _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.comparatorSelectAriaLabel', {
      defaultMessage: 'Comparator'
    }),
    onChange: e => {
      setWatchProperty('thresholdComparator', e.target.value);
    },
    options: Object.values(_comparators.comparators).map(({
      text,
      value
    }) => {
      return {
        text,
        value
      };
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 771,
      columnNumber: 25
    }
  })), Array.from(Array(_comparators.comparators[watch.thresholdComparator].requiredValues)).map((_notUsed, i) => {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: `threshold${i}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 790,
        columnNumber: 29
      }
    }, i > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: styles.watcherThresholdInBetweenComparatorText,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 792,
        columnNumber: 33
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 796,
        columnNumber: 35
      }
    }, andThresholdText), hasErrors && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 797,
        columnNumber: 49
      }
    })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 800,
        columnNumber: 31
      }
    }, /*#__PURE__*/_react.default.createElement(_components.ErrableFormRow, {
      errorKey: `threshold${i}`,
      isShowingErrors: hasErrors,
      errors: errors,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 801,
        columnNumber: 33
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      "data-test-subj": "watchThresholdInput",
      value: watch.threshold[i] == null ? '' : watch.threshold[i],
      min: 0,
      step: 0.1,
      onChange: e => {
        const {
          value
        } = e.target;
        const threshold = value !== '' ? parseFloat(value) : value;
        const newThreshold = [...watch.threshold];
        newThreshold[i] = threshold;
        setWatchProperty('threshold', newThreshold);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 806,
        columnNumber: 35
      }
    }))));
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 829,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "watchDurationPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.forTheLastLabel', {
        defaultMessage: 'for the last'
      }),
      value: `${watch.timeWindowSize} ${(0, _get_time_unit_label.getTimeUnitLabel)(watch.timeWindowUnit, parseInt(watch.timeWindowSize, 10).toString())}`,
      isActive: watchDurationPopoverOpen || !watch.timeWindowSize,
      onClick: () => {
        setWatchDurationPopoverOpen(true);
      },
      color: watch.timeWindowSize ? 'success' : 'danger',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 833,
        columnNumber: 21
      }
    }),
    isOpen: watchDurationPopoverOpen,
    closePopover: () => {
      setWatchDurationPopoverOpen(false);
    },
    ownFocus: true,
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 830,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 858,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 859,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.sections.watchEdit.threshold.forTheLastButtonLabel",
    defaultMessage: "For the last",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 860,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 865,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 866,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_components.ErrableFormRow, {
    errorKey: "timeWindowSize",
    isShowingErrors: hasErrors,
    errors: errors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 867,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    min: 1,
    value: watch.timeWindowSize || '',
    onChange: e => {
      const {
        value
      } = e.target;
      const timeWindowSize = value !== '' ? parseInt(value, 10) : value;
      setWatchProperty('timeWindowSize', timeWindowSize);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 872,
      columnNumber: 27
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 883,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    value: watch.timeWindowUnit,
    "aria-label": _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.timeWindowUnitSelectAriaLabel', {
      defaultMessage: 'Time window unit'
    }),
    onChange: e => {
      setWatchProperty('timeWindowUnit', e.target.value);
    },
    options: getTimeOptions(watch.timeWindowSize),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 884,
      columnNumber: 25
    }
  }))))))), hasExpressionErrors ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 904,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 905,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 906,
      columnNumber: 17
    }
  }, expressionErrorMessage), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 909,
      columnNumber: 17
    }
  })) : null, hasErrors ? null : /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 913,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_watch_visualization.WatchVisualization, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 914,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_threshold_watch_action_panel.WatchActionsPanel, {
    actionErrors: actionErrors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 915,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 918,
      columnNumber: 13
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 922,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 923,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 924,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 925,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "success",
    "data-test-subj": "saveWatchButton",
    type: "submit",
    iconType: "check",
    disabled: hasErrors || hasActionErrors,
    isLoading: isSaving,
    onClick: async () => {
      setIsSaving(true);
      const savedWatch = await (0, _watch_edit_actions.onWatchSave)(watch, toasts);
      if (savedWatch && savedWatch.error) {
        setIsSaving(false);
        return setServerError(savedWatch.error);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 926,
      columnNumber: 17
    }
  }, watch.isNew ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.sections.watchEdit.threshold.createButtonLabel",
    defaultMessage: "Create alert",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 944,
      columnNumber: 21
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.sections.watchEdit.threshold.saveButtonLabel",
    defaultMessage: "Save alert",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 949,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 957,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => (0, _navigation.goToWatchList)(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 958,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 967,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => setIsRequestVisible(!isRequestVisible),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 968,
      columnNumber: 13
    }
  }, isRequestVisible ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.sections.watchEdit.json.hideRequestButtonLabel",
    defaultMessage: "Hide request",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 970,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.sections.watchEdit.json.showRequestButtonLabel",
    defaultMessage: "Show request",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 975,
      columnNumber: 17
    }
  }))))), isRequestVisible ? /*#__PURE__*/_react.default.createElement(_request_flyout.RequestFlyout, {
    id: watch.id,
    payload: (0, _serialization.serializeThresholdWatch)(requestPreviewWatchData),
    close: () => setIsRequestVisible(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 986,
      columnNumber: 9
    }
  }) : null);
};
exports.ThresholdWatchEdit = ThresholdWatchEdit;