"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WatchActionsAccordion = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _action = require("../../../../models/action");
var _watch_history_item = require("../../../../models/watch_history_item");
var _threshold_watch = require("../../../../models/watch/threshold_watch");
var _execute_details = require("../../../../models/execute_details");
var _constants = require("../../../../../../common/constants");
var _watch_context = require("../../watch_context");
var _action_fields = require("./action_fields");
var _api = require("../../../../lib/api");
var _components = require("../../../../components");
var _app_context = require("../../../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/watcher/public/application/sections/watch_edit_page/components/threshold_watch_edit/threshold_watch_action_accordion.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    watcherThresholdDeleteButton: (0, _react2.css)`
      opacity: 0;

      &:focus,
      .euiAccordion:hover & {
        opacity: 1;
      }

      ${_eui.euiCanAnimate} {
        transition: opacity ${euiTheme.animation.normal} ${euiTheme.animation.resistance};
      }
    `
  };
};
const actionFieldsComponentMap = {
  [_constants.ACTION_TYPES.LOGGING]: _action_fields.LoggingActionFields,
  [_constants.ACTION_TYPES.SLACK]: _action_fields.SlackActionFields,
  [_constants.ACTION_TYPES.EMAIL]: _action_fields.EmailActionFields,
  [_constants.ACTION_TYPES.INDEX]: _action_fields.IndexActionFields,
  [_constants.ACTION_TYPES.WEBHOOK]: _action_fields.WebhookActionFields,
  [_constants.ACTION_TYPES.PAGERDUTY]: _action_fields.PagerDutyActionFields,
  [_constants.ACTION_TYPES.JIRA]: _action_fields.JiraActionFields
};
const WatchActionsAccordion = ({
  settings,
  actionErrors
}) => {
  const styles = useStyles();
  const {
    links: {
      watchActionsConfigurationMap
    },
    toasts
  } = (0, _app_context.useAppContext)();
  const {
    watch,
    setWatchProperty
  } = (0, _react.useContext)(_watch_context.WatchContext);
  const {
    actions
  } = watch;
  const [isExecuting, setIsExecuting] = (0, _react.useState)({});
  const [executeResultsError, setExecuteResultsError] = (0, _react.useState)(null);
  if (actions && actions.length >= 1) {
    return actions.map(action => {
      const FieldsComponent = actionFieldsComponentMap[action.type];
      const errors = actionErrors[action.id];
      const hasErrors = !!Object.keys(errors).find(errorKey => errors[errorKey].length >= 1);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
        initialIsOpen: action.isNew || hasErrors // If an action contains errors in edit mode, we want the accordion open so the user is aware
        ,
        key: action.id,
        id: action.id,
        borders: "horizontal",
        buttonProps: {
          paddingSize: 'm',
          css: (0, _react2.css)`
              &:hover {
                text-decoration: none;
              }
            `
        },
        "data-test-subj": "watchActionAccordion",
        buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 133,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 134,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: action.iconClass,
          size: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 135,
            columnNumber: 17
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 137,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
          size: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 138,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement("h6", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 139,
            columnNumber: 19
          }
        }, action.typeName)))),
        extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          iconType: "cross",
          color: "danger",
          css: styles.watcherThresholdDeleteButton,
          "aria-label": _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.accordion.deleteIconAriaLabel', {
            defaultMessage: 'Delete'
          }),
          onClick: () => {
            const updatedActions = actions.filter(actionItem => actionItem.id !== action.id);
            setWatchProperty('actions', updatedActions);
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 145,
            columnNumber: 13
          }
        }),
        paddingSize: "l",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 9
        }
      }, executeResultsError && executeResultsError[action.id] && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 166,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_components.SectionError, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.watcher.sections.watchEdit.threshold.accordion.simulateResultsErrorTitle",
          defaultMessage: "Error testing action",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 169,
            columnNumber: 19
          }
        }),
        error: executeResultsError[action.id],
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 15
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 176,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 179,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(FieldsComponent, {
        action: action,
        errors: errors,
        hasErrors: hasErrors,
        editAction: changedProperty => {
          const updatedActions = actions.map(actionItem => {
            if (actionItem.id === action.id) {
              const ActionTypes = _action.Action.getActionTypes();
              const ActionTypeModel = ActionTypes[action.type];
              const {
                key,
                value
              } = changedProperty;
              return new ActionTypeModel({
                ...action,
                [key]: value
              });
            }
            return actionItem;
          });
          setWatchProperty('actions', updatedActions);
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 180,
          columnNumber: 13
        }
      }, settings && settings.actionTypes[action.type].enabled === false ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 198,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        announceOnMount: true,
        title: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.actions.actionConfigurationWarningTitleText', {
          defaultMessage: 'Account may not be configured'
        }),
        color: "warning",
        iconType: "question",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 210,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 211,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.watcher.sections.watchEdit.threshold.actions.actionConfigurationWarningDescriptionText",
        defaultMessage: "To create this action, you must configure at least one {accountType} account. {docLink}",
        values: {
          accountType: action.typeName,
          docLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: watchActionsConfigurationMap[action.type],
            target: "_blank",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 218,
              columnNumber: 31
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.watcher.sections.watchEdit.threshold.actions.actionConfigurationWarningHelpLinkText",
            defaultMessage: "Learn more.",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 222,
              columnNumber: 33
            }
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 212,
          columnNumber: 25
        }
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 233,
          columnNumber: 19
        }
      })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        type: "submit",
        isDisabled: hasErrors,
        isLoading: isExecuting[action.id],
        "data-test-subj": "simulateActionButton",
        onClick: async () => {
          const selectedWatchAction = watch.actions.filter(watchAction => watchAction.id === action.id);
          const executeDetails = new _execute_details.ExecuteDetails({
            ignoreCondition: true,
            recordExecution: false,
            actionModes: {
              [action.id]: _constants.ACTION_MODES.FORCE_EXECUTE
            }
          });
          const newExecuteWatch = new _threshold_watch.ThresholdWatch({
            ...watch,
            actions: selectedWatchAction
          });
          setIsExecuting({
            [action.id]: true
          });
          setExecuteResultsError(null);
          const {
            data,
            error
          } = await (0, _api.executeWatch)(executeDetails, newExecuteWatch);
          setIsExecuting({
            [action.id]: false
          });
          if (error) {
            return setExecuteResultsError({
              [action.id]: error
            });
          }
          const formattedResults = _watch_history_item.WatchHistoryItem.fromUpstreamJson(data.watchHistoryItem);
          const actionStatuses = formattedResults.watchStatus.actionStatuses;
          const actionStatus = actionStatuses.find(actionItem => actionItem.id === action.id);
          if (actionStatus && actionStatus.isLastExecutionSuccessful === false) {
            const message = actionStatus.lastExecutionReason || action.simulateFailMessage;
            return toasts.addDanger(message);
          }
          return toasts.addSuccess(action.simulateMessage);
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 238,
          columnNumber: 13
        }
      }, action.simulatePrompt)));
    });
  }
  return null;
};
exports.WatchActionsAccordion = WatchActionsAccordion;