"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WebhookActionFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _codeEditor = require("@kbn/code-editor");
var _form_errors = require("../../../../../components/form_errors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/watcher/public/application/sections/watch_edit_page/components/threshold_watch_edit/action_fields/webhook_action_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HTTP_VERBS = ['head', 'get', 'post', 'put', 'delete'];
const SCHEME = ['http', 'https'];
const WebhookActionFields = ({
  action,
  editAction,
  errors,
  hasErrors
}) => {
  const {
    method,
    host,
    port,
    scheme,
    path,
    body,
    username,
    password
  } = action;
  (0, _react.useEffect)(() => {
    editAction({
      key: 'contentType',
      value: 'application/json'
    }); // set content-type for threshold watch to json by default
  }, [editAction]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.webhookAction.methodFieldLabel', {
      defaultMessage: 'Method'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    name: "method",
    value: method || 'get',
    "data-test-subj": "webhookMethodSelect",
    options: HTTP_VERBS.map(verb => ({
      text: verb.toUpperCase(),
      value: verb
    })),
    onChange: e => {
      editAction({
        key: 'method',
        value: e.target.value
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.webhookAction.schemeFieldLabel', {
      defaultMessage: 'Scheme'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    name: "scheme",
    value: scheme,
    "data-test-subj": "webhookSchemeSelect",
    options: SCHEME.map(verb => ({
      text: verb,
      value: verb
    })),
    onChange: e => {
      editAction({
        key: 'scheme',
        value: e.target.value
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_form_errors.ErrableFormRow, {
    id: "webhookHost",
    errorKey: "host",
    fullWidth: true,
    errors: errors,
    isShowingErrors: hasErrors && host !== undefined,
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.webhookAction.hostFieldLabel', {
      defaultMessage: 'Host'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    name: "host",
    value: host || '',
    "data-test-subj": "webhookHostInput",
    onChange: e => {
      editAction({
        key: 'host',
        value: e.target.value
      });
    },
    onBlur: () => {
      if (!host) {
        editAction({
          key: 'host',
          value: ''
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_form_errors.ErrableFormRow, {
    id: "webhookPort",
    errorKey: "port",
    fullWidth: true,
    errors: errors,
    isShowingErrors: hasErrors && port !== undefined,
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.webhookAction.methodPortLabel', {
      defaultMessage: 'Port'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    prepend: ":",
    fullWidth: true,
    name: "port",
    value: port || '',
    "data-test-subj": "webhookPortInput",
    onChange: e => {
      editAction({
        key: 'port',
        value: parseInt(e.target.value, 10)
      });
    },
    onBlur: () => {
      if (!port) {
        editAction({
          key: 'port',
          value: ''
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.webhookAction.pathFieldLabel', {
      defaultMessage: 'Path (optional)'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    prepend: "/",
    fullWidth: true,
    name: "path",
    value: path || '',
    "data-test-subj": "webhookPathInput",
    onChange: e => {
      editAction({
        key: 'path',
        value: e.target.value
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_form_errors.ErrableFormRow, {
    id: "webhookBasicAuthUsername",
    errorKey: "username",
    isShowingErrors: hasErrors,
    errors: errors,
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.webhookAction.basicAuthUsername', {
      defaultMessage: 'Username (optional)'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "username",
    value: username || '',
    "data-test-subj": "webhookUsernameInput",
    onChange: e => {
      editAction({
        key: 'username',
        value: e.target.value
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_form_errors.ErrableFormRow, {
    id: "webhookBasicAuthPassword",
    errorKey: "password",
    isShowingErrors: hasErrors,
    errors: errors,
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.webhookAction.basicAuthPassword', {
      defaultMessage: 'Password (optional)'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
    name: "password",
    value: password || '',
    "data-test-subj": "webhookPasswordInput",
    onChange: e => {
      editAction({
        key: 'password',
        value: e.target.value
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_form_errors.ErrableFormRow, {
    id: "webhookBody",
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.webhookAction.bodyFieldLabel', {
      defaultMessage: 'Body'
    }),
    errorKey: "body",
    isShowingErrors: hasErrors,
    fullWidth: true,
    errors: errors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: "json",
    value: body || '',
    "data-test-subj": "webhookBodyEditor",
    height: 200,
    options: {
      lineNumbers: 'off',
      tabSize: 2,
      scrollBeyondLastLine: false
    },
    "aria-label": _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.webhookAction.bodyCodeEditorAriaLabel', {
      defaultMessage: 'Code editor'
    }),
    onChange: json => {
      editAction({
        key: 'body',
        value: json
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 9
    }
  })));
};
exports.WebhookActionFields = WebhookActionFields;