"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JiraActionFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _form_errors = require("../../../../../components/form_errors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/watcher/public/application/sections/watch_edit_page/components/threshold_watch_edit/action_fields/jira_action_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JiraActionFields = ({
  action,
  editAction,
  errors,
  hasErrors,
  children
}) => {
  const {
    projectKey,
    issueType,
    summary
  } = action;
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, children, /*#__PURE__*/_react.default.createElement(_form_errors.ErrableFormRow, {
    id: "jiraProjectKey",
    errorKey: "projectKey",
    fullWidth: true,
    errors: errors,
    isShowingErrors: hasErrors && projectKey !== undefined,
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.jiraAction.projectKeyFieldLabel', {
      defaultMessage: 'Project key'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    name: "projectKey",
    value: projectKey || '',
    "data-test-subj": "jiraProjectKeyInput",
    onChange: e => {
      editAction({
        key: 'projectKey',
        value: e.target.value
      });
    },
    onBlur: () => {
      if (!projectKey) {
        editAction({
          key: 'projectKey',
          value: ''
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_form_errors.ErrableFormRow, {
    id: "jiraIssueType",
    errorKey: "issueType",
    fullWidth: true,
    errors: errors,
    isShowingErrors: hasErrors && issueType !== undefined,
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.jiraAction.issueTypeFieldLabel', {
      defaultMessage: 'Issue type'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    value: issueType || '',
    name: "issueType",
    "data-test-subj": "jiraIssueTypeInput",
    onChange: e => {
      editAction({
        key: 'issueType',
        value: e.target.value
      });
    },
    onBlur: () => {
      if (!issueType) {
        editAction({
          key: 'issueType',
          value: ''
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_form_errors.ErrableFormRow, {
    id: "jiraSummary",
    errorKey: "summary",
    fullWidth: true,
    errors: errors,
    isShowingErrors: hasErrors && summary !== undefined,
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.jiraAction.summaryFieldLabel', {
      defaultMessage: 'Summary'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    value: summary || '',
    name: "summary",
    "data-test-subj": "jiraSummaryInput",
    onChange: e => {
      editAction({
        key: 'summary',
        value: e.target.value
      });
    },
    onBlur: () => {
      if (!summary) {
        editAction({
          key: 'summary',
          value: ''
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  })));
};
exports.JiraActionFields = JiraActionFields;