"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimulateWatchResultsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _components = require("../../../../components");
var _watch_edit_actions = require("../../watch_edit_actions");
var _watch_context = require("../../watch_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/watcher/public/application/sections/watch_edit_page/components/json_watch_edit/simulate_watch_results_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SimulateWatchResultsFlyout = ({
  executeResults,
  executeDetails,
  onCloseFlyout,
  error
}) => {
  var _details$result, _details$result$condi, _details$result2, _details$result2$cond;
  const {
    watch
  } = (0, _react.useContext)(_watch_context.WatchContext);
  const {
    actionModes
  } = executeDetails;
  const conditionNotMetActionStatus = mode => {
    switch (mode) {
      case 'simulate':
      case 'force_simulate':
        return _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulateResults.table.statusColumnValue.notSimulated', {
          defaultMessage: 'not simulated'
        });
      case 'execute':
      case 'force_execute':
        return _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulateResults.table.statusColumnValue.notExecuted', {
          defaultMessage: 'not executed'
        });
      case 'skip':
        return _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulateResults.table.statusColumnValue.throttled', {
          defaultMessage: 'throttled'
        });
      default:
        return '';
    }
  };
  const getTableData = () => {
    const actions = watch.watch && watch.watch.actions;
    if (executeResults && actions) {
      const actionStatuses = executeResults.watchStatus && executeResults.watchStatus.actionStatuses;
      return Object.keys(actions).map(actionKey => {
        var _executeResults$detai, _executeResults$detai2, _executeResults$detai3, _executeResults$detai4, _executeResults$detai5, _executeResults$detai6;
        const actionStatus = actionStatuses.find(status => status.id === actionKey);
        const isConditionMet = (_executeResults$detai = executeResults.details) === null || _executeResults$detai === void 0 ? void 0 : (_executeResults$detai2 = _executeResults$detai.result) === null || _executeResults$detai2 === void 0 ? void 0 : (_executeResults$detai3 = _executeResults$detai2.condition) === null || _executeResults$detai3 === void 0 ? void 0 : _executeResults$detai3.met;
        return {
          actionId: actionKey,
          actionType: (0, _watch_edit_actions.getTypeFromAction)(actions[actionKey]),
          actionMode: actionModes[actionKey],
          actionState: actionStatus && actionStatus.state,
          actionReason: actionStatus && actionStatus.lastExecutionReason,
          actionStatus: isConditionMet && ((_executeResults$detai4 = executeResults.details) === null || _executeResults$detai4 === void 0 ? void 0 : (_executeResults$detai5 = _executeResults$detai4.result) === null || _executeResults$detai5 === void 0 ? void 0 : (_executeResults$detai6 = _executeResults$detai5.actions.find(action => action.id === actionKey)) === null || _executeResults$detai6 === void 0 ? void 0 : _executeResults$detai6.status) || conditionNotMetActionStatus(actionModes[actionKey])
        };
      });
    }
    return [];
  };
  const actionsTableData = getTableData();
  const columns = [{
    field: 'actionId',
    name: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulateResults.table.actionColumnLabel', {
      defaultMessage: 'ID'
    }),
    sortable: true,
    truncateText: true
  }, {
    field: 'actionType',
    name: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulateResults.table.typeColumnLabel', {
      defaultMessage: 'Type'
    }),
    truncateText: true
  }, {
    field: 'actionMode',
    name: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulateResults.table.modeColumnLabel', {
      defaultMessage: 'Mode'
    })
  }, {
    field: 'actionState',
    name: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulateResults.table.stateColumnLabel', {
      defaultMessage: 'State'
    }),
    dataType: 'string',
    render: (actionState, _item) => /*#__PURE__*/_react.default.createElement(_components.ActionStateBadge, {
      state: actionState,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 9
      }
    })
  }, {
    field: 'actionReason',
    name: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulateResults.table.reasonColumnLabel', {
      defaultMessage: 'Reason'
    })
  }, {
    field: 'actionStatus',
    name: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulateResults.table.statusColumnLabel', {
      defaultMessage: 'Status'
    })
  }];
  const flyoutTitle = /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "simulateResultsFlyOutTitle",
    "data-test-subj": "simulateResultsFlyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulateResults.title', {
    defaultMessage: 'Simulation results'
  })));
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      onClose: () => {
        onCloseFlyout();
      },
      "aria-labelledby": "simulateResultsFlyOutTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 9
      }
    }, flyoutTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_components.SectionError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.watcher.sections.watchEdit.simulateResults.errorTitle",
        defaultMessage: "Cannot simulate watch",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 190,
          columnNumber: 15
        }
      }),
      error: error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 11
      }
    })));
  }
  if (!executeResults) {
    return null;
  }
  const {
    details
  } = executeResults;
  const conditionMetStatus = (details === null || details === void 0 ? void 0 : (_details$result = details.result) === null || _details$result === void 0 ? void 0 : (_details$result$condi = _details$result.condition) === null || _details$result$condi === void 0 ? void 0 : _details$result$condi.met) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "green",
    type: "check",
    "data-test-subj": "conditionMetStatus",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 7
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.sections.watchEdit.simulateResults.conditionMetStatus",
    defaultMessage: "Condition met",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 7
    }
  })) || /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "subdued",
    type: "cross",
    "data-test-subj": "conditionNotMetStatus",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 7
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.sections.watchEdit.simulateResults.conditionNotMetStatus",
    defaultMessage: "Condition not met",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => {
      onCloseFlyout();
    },
    "data-test-subj": "simulateResultsFlyout",
    "aria-labelledby": "simulateResultsFlyOutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 7
    }
  }, flyoutTitle, (details === null || details === void 0 ? void 0 : (_details$result2 = details.result) === null || _details$result2 === void 0 ? void 0 : (_details$result2$cond = _details$result2.condition) === null || _details$result2$cond === void 0 ? void 0 : _details$result2$cond.met) != null && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 13
    }
  }), conditionMetStatus)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 7
    }
  }, actionsTableData && actionsTableData.length > 0 && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulateResults.actionsSectionTitle', {
    defaultMessage: 'Actions'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: actionsTableData,
    "data-test-subj": "simulateResultsTable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulateResults.simulationOutputSectionTitle', {
    defaultMessage: 'Simulation output'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 9
    }
  }, JSON.stringify(details, null, 2))));
};
exports.SimulateWatchResultsFlyout = SimulateWatchResultsFlyout;