"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonWatchEditSimulate = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _codeEditor = require("@kbn/code-editor");
var _watch_history_item = require("../../../../models/watch_history_item");
var _constants = require("../../../../../../common/constants");
var _execute_details = require("../../../../models/execute_details");
var _components = require("../../../../components");
var _api = require("../../../../lib/api");
var _watch_context = require("../../watch_context");
var _simulate_watch_results_flyout = require("./simulate_watch_results_flyout");
var _get_time_unit_label = require("../../../../lib/get_time_unit_label");
var _app_context = require("../../../../app_context");
var _shared_imports = require("../../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/watcher/public/application/sections/watch_edit_page/components/json_watch_edit/json_watch_edit_simulate.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  useXJsonMode
} = _shared_imports.XJson;
const actionModeOptions = Object.keys(_constants.ACTION_MODES).map(mode => ({
  text: _constants.ACTION_MODES[mode],
  value: _constants.ACTION_MODES[mode]
}));
const getScheduleTimeOptions = (unitSize = '0') => Object.entries(_constants.TIME_UNITS).filter(([key]) => key !== _constants.TIME_UNITS.DAY).map(([_key, value]) => {
  return {
    text: (0, _get_time_unit_label.getTimeUnitLabel)(value, unitSize),
    value
  };
});
const JsonWatchEditSimulate = ({
  executeWatchErrors,
  hasExecuteWatchErrors,
  executeDetails,
  setExecuteDetails,
  watchActions
}) => {
  const {
    links: {
      executeWatchApiUrl
    }
  } = (0, _app_context.useAppContext)();
  const {
    watch
  } = (0, _react.useContext)(_watch_context.WatchContext);

  // hooks
  const [executeResults, setExecuteResults] = (0, _react.useState)(null);
  const [isExecuting, setIsExecuting] = (0, _react.useState)(false);
  const [executeResultsError, setExecuteResultsError] = (0, _react.useState)(null);
  const {
    errors: watchErrors
  } = watch.validate();
  const hasWatchJsonError = watchErrors.json.length >= 1;
  const {
    actionModes,
    scheduledTimeValue,
    scheduledTimeUnit,
    triggeredTimeValue,
    alternativeInput,
    ignoreCondition
  } = executeDetails;
  const {
    setXJson,
    convertToJson,
    xJson
  } = useXJsonMode(alternativeInput);
  const columns = [{
    field: 'actionId',
    name: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulate.table.idColumnLabel', {
      defaultMessage: 'ID'
    }),
    sortable: true,
    truncateText: true
  }, {
    field: 'type',
    name: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulate.table.typeColumnLabel', {
      defaultMessage: 'Type'
    }),
    truncateText: true
  }, {
    field: 'actionMode',
    name: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulate.table.modeColumnLabel', {
      defaultMessage: 'Mode'
    }),
    render: ({}, row) => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      options: actionModeOptions,
      value: actionModes[row.actionId],
      "data-test-subj": "actionModesSelect",
      onChange: e => {
        setExecuteDetails(new _execute_details.ExecuteDetails({
          ...executeDetails,
          actionModes: {
            ...actionModes,
            [row.actionId]: e.target.value
          }
        }));
      },
      "aria-label": _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulate.table.modeSelectLabel', {
        defaultMessage: 'Action modes'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 9
      }
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulate.pageDescription', {
    defaultMessage: 'Use the simulator to override the watch schedule, condition, actions, and input results.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": "jsonWatchSimulateForm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulate.form.triggerOverridesTitle', {
      defaultMessage: 'Trigger'
    })),
    description: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulate.form.triggerOverridesDescription', {
      defaultMessage: 'Set the time and date for starting the watch.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulate.form.scheduledTimeFieldLabel', {
      defaultMessage: 'Schedule every'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: scheduledTimeValue == null || scheduledTimeValue === '' ? scheduledTimeValue : parseInt(scheduledTimeValue, 10),
    min: 0,
    "data-test-subj": "scheduledTimeInput",
    onChange: e => {
      const value = e.target.value;
      setExecuteDetails(new _execute_details.ExecuteDetails({
        ...executeDetails,
        scheduledTimeValue: value === '' ? value : parseInt(value, 10)
      }));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    value: scheduledTimeUnit,
    options: getScheduleTimeOptions(scheduledTimeValue),
    onChange: e => {
      setExecuteDetails(new _execute_details.ExecuteDetails({
        ...executeDetails,
        scheduledTimeUnit: e.target.value
      }));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulate.form.triggeredTimeFieldLabel', {
      defaultMessage: 'Trigger after'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: triggeredTimeValue == null || triggeredTimeValue === '' ? triggeredTimeValue : parseInt(triggeredTimeValue, 10),
    min: 0,
    "data-test-subj": "triggeredTimeInput",
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 17
      }
    }, (0, _get_time_unit_label.getTimeUnitLabel)(_constants.TIME_UNITS.SECOND, triggeredTimeValue)),
    onChange: e => {
      const value = e.target.value;
      setExecuteDetails(new _execute_details.ExecuteDetails({
        ...executeDetails,
        triggeredTimeValue: value === '' ? value : parseInt(value, 10),
        triggeredTimeUnit: _constants.TIME_UNITS.SECOND
      }));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 261,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulate.form.conditionOverridesTitle', {
      defaultMessage: 'Condition'
    })),
    description: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulate.form.conditionOverridesDescription', {
      defaultMessage: 'Execute the watch when the condition is met. Otherwise, ignore the condition and run the watch on a fixed schedule.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulate.form.ignoreConditionFieldLabel', {
      defaultMessage: 'Ignore condition'
    }),
    checked: ignoreCondition,
    "data-test-subj": "ignoreConditionSwitch",
    onChange: e => {
      setExecuteDetails(new _execute_details.ExecuteDetails({
        ...executeDetails,
        ignoreCondition: e.target.checked
      }));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 296,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulate.form.actionOverridesTitle', {
      defaultMessage: 'Actions'
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchEdit.simulate.form.actionOverridesDescription",
      defaultMessage: "Allow the watch to execute or skip actions. {actionsLink}",
      values: {
        actionsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: executeWatchApiUrl,
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 309,
            columnNumber: 19
          }
        }, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulate.form.actionOverridesDescription.linkLabel', {
          defaultMessage: 'Learn about actions.'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 304,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulate.form.actionModesFieldLabel', {
      defaultMessage: 'Action modes'
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: watchActions,
    itemId: "simulateExecutionActionModesTable",
    columns: columns,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 342,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulate.form.inputOverridesTitle', {
      defaultMessage: 'Input'
    })),
    description: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulate.form.inputOverridesDescription', {
      defaultMessage: 'Enter JSON data to override the watch payload that comes from running the input.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 339,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_components.ErrableFormRow, {
    id: "executeWatchJson",
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulate.form.alternativeInputFieldLabel', {
      defaultMessage: 'Alternative input'
    }),
    errorKey: "json",
    isShowingErrors: hasExecuteWatchErrors,
    fullWidth: true,
    errors: executeWatchErrors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 357,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: "json",
    value: xJson,
    "data-test-subj": "jsonEditor",
    height: 200,
    options: {
      fontSize: 12,
      tabSize: 2,
      scrollBeyondLastLine: false
    },
    "aria-label": _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulate.form.alternativeInputAriaLabel', {
      defaultMessage: 'Code editor'
    }),
    onChange: xjson => {
      setXJson(xjson);
      setExecuteDetails(new _execute_details.ExecuteDetails({
        ...executeDetails,
        alternativeInput: convertToJson(xjson)
      }));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 370,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "play",
    "data-test-subj": "simulateWatchButton",
    fill: true,
    type: "submit",
    isLoading: isExecuting,
    isDisabled: hasExecuteWatchErrors || hasWatchJsonError,
    onClick: async () => {
      setIsExecuting(true);
      const {
        data,
        error
      } = await (0, _api.executeWatch)(executeDetails, watch);
      setIsExecuting(false);
      if (error) {
        return setExecuteResultsError(error);
      }
      const formattedResults = _watch_history_item.WatchHistoryItem.fromUpstreamJson(data.watchHistoryItem);
      setExecuteResults(formattedResults);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 398,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulate.form.saveButtonLabel', {
    defaultMessage: 'Simulate watch'
  }))), /*#__PURE__*/_react.default.createElement(_simulate_watch_results_flyout.SimulateWatchResultsFlyout, {
    executeResults: executeResults,
    executeDetails: executeDetails,
    error: executeResultsError,
    onCloseFlyout: () => {
      setExecuteResults(null);
      setExecuteResultsError(null);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 426,
      columnNumber: 7
    }
  }));
};
exports.JsonWatchEditSimulate = JsonWatchEditSimulate;