"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageError = PageError;
exports.getPageErrorCode = getPageErrorCode;
var _react = _interopRequireDefault(require("react"));
var _page_error_not_exist = require("./page_error_not_exist");
var _page_error_forbidden = require("./page_error_forbidden");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/watcher/public/application/components/page_error/page_error.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getPageErrorCode(errorOrErrors) {
  const errors = Array.isArray(errorOrErrors) ? errorOrErrors : [errorOrErrors];
  const firstError = errors.find(error => {
    if (error) {
      return [403, 404].includes(error.statusCode);
    }
    return false;
  });
  if (firstError) {
    return firstError.statusCode;
  }
}
function PageError({
  errorCode,
  id
}) {
  switch (errorCode) {
    case 404:
      return /*#__PURE__*/_react.default.createElement(_page_error_not_exist.PageErrorNotExist, {
        id: id,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 31,
          columnNumber: 14
        }
      });
    case 403:
    default:
      return /*#__PURE__*/_react.default.createElement(_page_error_forbidden.PageErrorForbidden, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 35,
          columnNumber: 14
        }
      });
  }
}