"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteWatchesModal = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _api = require("../lib/api");
var _app_context = require("../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/watcher/public/application/components/delete_watches_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DeleteWatchesModal = ({
  watchesToDelete,
  callback
}) => {
  const {
    toasts
  } = (0, _app_context.useAppContext)();
  const numWatchesToDelete = watchesToDelete.length;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'deleteWatchModal'
  });
  if (!numWatchesToDelete) {
    return null;
  }
  const confirmModalText = _i18n.i18n.translate('xpack.watcher.deleteSelectedWatchesConfirmModal.descriptionText', {
    defaultMessage: "You can't recover {numWatchesToDelete, plural, one {a deleted watch} other {deleted watches}}.",
    values: {
      numWatchesToDelete
    }
  });
  const confirmButtonText = _i18n.i18n.translate('xpack.watcher.deleteSelectedWatchesConfirmModal.deleteButtonLabel', {
    defaultMessage: 'Delete {numWatchesToDelete, plural, one {watch} other {# watches}} ',
    values: {
      numWatchesToDelete
    }
  });
  const cancelButtonText = _i18n.i18n.translate('xpack.watcher.deleteSelectedWatchesConfirmModal.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    buttonColor: "danger",
    "data-test-subj": "deleteWatchesConfirmation",
    title: confirmButtonText,
    onCancel: () => callback(),
    onConfirm: async () => {
      const {
        successes,
        errors
      } = await (0, _api.deleteWatches)(watchesToDelete);
      const numSuccesses = successes.length;
      const numErrors = errors.length;
      callback(successes);
      if (numSuccesses > 0) {
        toasts.addSuccess(_i18n.i18n.translate('xpack.watcher.sections.watchList.deleteSelectedWatchesSuccessNotification.descriptionText', {
          defaultMessage: 'Deleted {numSuccesses, number} {numSuccesses, plural, one {watch} other {watches}}',
          values: {
            numSuccesses
          }
        }));
      }
      if (numErrors > 0) {
        toasts.addDanger(_i18n.i18n.translate('xpack.watcher.sections.watchList.deleteSelectedWatchesErrorNotification.descriptionText', {
          defaultMessage: 'Failed to delete {numErrors, number} {numErrors, plural, one {watch} other {watches}}',
          values: {
            numErrors
          }
        }));
      }
    },
    cancelButtonText: cancelButtonText,
    confirmButtonText: confirmButtonText,
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, confirmModalText);
};
exports.DeleteWatchesModal = DeleteWatchesModal;