"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppWithoutRouter = exports.App = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _sections = require("./sections");
var _navigation = require("./lib/navigation");
var _app_context = require("./app_context");
var _license_prompt = require("./license_prompt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/watcher/public/application/app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ShareRouter = (0, _reactRouterDom.withRouter)(({
  children,
  history
}) => {
  (0, _navigation.registerRouter)({
    history
  });
  return children;
});
const App = deps => {
  const [{
    valid,
    message
  }, setLicenseStatus] = (0, _react.useState)({
    valid: true
  });
  (0, _react.useEffect)(() => {
    const s = deps.licenseStatus$.subscribe(setLicenseStatus);
    return () => s.unsubscribe();
  }, [deps.licenseStatus$]);
  if (!valid) {
    return /*#__PURE__*/_react.default.createElement(_license_prompt.LicensePrompt, {
      licenseManagementLocator: deps.licenseManagementLocator,
      message: message,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: deps.history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(ShareRouter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_app_context.AppContextProvider, {
    value: deps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(AppWithoutRouter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }))));
};

// Export this so we can test it with a different router.
exports.App = App;
const AppWithoutRouter = () => /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 90,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/watches",
  component: _sections.WatchListPage,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 91,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/watches/watch/:id/status",
  component: _sections.WatchStatusPage,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 92,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/watches/watch/:id/edit",
  component: _sections.WatchEditPage,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 93,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/watches/new-watch/:type(json|threshold)",
  component: _sections.WatchEditPage,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 94,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
  exact: true,
  from: "/",
  to: "/watches",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 95,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
  exact: true,
  from: "",
  to: "/watches",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 96,
    columnNumber: 5
  }
}));
exports.AppWithoutRouter = AppWithoutRouter;