"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInAppUrl = getInAppUrl;
var _read_only_vis_type_registry = require("./read_only_vis_type_registry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getInAppUrl(obj) {
  let visType;
  if (obj.attributes.visState) {
    try {
      const visState = JSON.parse(obj.attributes.visState);
      visType = visState === null || visState === void 0 ? void 0 : visState.type;
    } catch (e) {
      // let client display warning for unparsable visState
    }
  }
  return (0, _read_only_vis_type_registry.isVisTypeReadOnly)(visType) ? undefined : {
    path: `/app/visualize#/edit/${encodeURIComponent(obj.id)}`,
    uiCapabilitiesPath: 'visualize_v2.show'
  };
}