"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _analytics = require("@kbn/analytics");
var _react2 = require("@emotion/react");
var _search_selection = require("./search_selection");
var _group_selection = require("./group_selection");
var _agg_based_selection = require("./agg_based_selection");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/visualizations/public/wizard/new_vis_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const modalWidth = ({
  euiTheme
}) => (0, _eui.mathWithUnits)(euiTheme.size.s, x => x * 100);
const modalHeight = ({
  euiTheme
}) => (0, _eui.mathWithUnits)(euiTheme.size.s, x => x * 90);
const lightSvg = `url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='313' height='461' viewBox='0 0 313 461'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cpath fill='%23F5F7FA' d='M294.009,184.137 C456.386,184.137 588.018,315.77 588.018,478.146 C588.018,640.523 456.386,772.156 294.009,772.156 C131.632,772.156 0,640.523 0,478.146 C0,315.77 131.632,184.137 294.009,184.137 Z M294.009,384.552 C242.318,384.552 200.415,426.456 200.415,478.146 C200.415,529.837 242.318,571.741 294.009,571.741 C345.7,571.741 387.604,529.837 387.604,478.146 C387.604,426.456 345.7,384.552 294.009,384.552 Z'/%3E%3Cpath fill='%23E6EBF2' d='M202.958,365.731 L202.958,380.991 L187.698,380.991 L187.698,365.731 L202.958,365.731 Z M202.958,327.073 L202.958,342.333 L187.698,342.333 L187.698,327.073 L202.958,327.073 Z M243.651,325.038 L243.651,340.298 L228.391,340.298 L228.391,325.038 L243.651,325.038 Z M243.651,286.379 L243.651,301.639 L228.391,301.639 L228.391,286.379 L243.651,286.379 Z M202.958,285.362 L202.958,300.622 L187.698,300.622 L187.698,285.362 L202.958,285.362 Z M284.345,284.345 L284.345,299.605 L269.085,299.605 L269.085,284.345 L284.345,284.345 Z M284.345,245.686 L284.345,260.946 L269.085,260.946 L269.085,245.686 L284.345,245.686 Z M243.651,244.669 L243.651,259.929 L228.391,259.929 L228.391,244.669 L243.651,244.669 Z M202.958,243.651 L202.958,258.911 L187.698,258.911 L187.698,243.651 L202.958,243.651 Z M284.345,203.975 L284.345,219.235 L269.085,219.235 L269.085,203.975 L284.345,203.975 Z M202.958,203.975 L202.958,219.235 L187.698,219.235 L187.698,203.975 L202.958,203.975 Z M243.651,202.958 L243.651,218.218 L228.391,218.218 L228.391,202.958 L243.651,202.958 Z M243.651,163.282 L243.651,178.542 L228.391,178.542 L228.391,163.282 L243.651,163.282 Z M202.958,163.282 L202.958,178.542 L187.698,178.542 L187.698,163.282 L202.958,163.282 Z M284.345,162.265 L284.345,177.525 L269.085,177.525 L269.085,162.265 L284.345,162.265 Z M284.345,122.589 L284.345,137.849 L269.085,137.849 L269.085,122.589 L284.345,122.589 Z M243.651,122.589 L243.651,137.849 L228.391,137.849 L228.391,122.589 L243.651,122.589 Z M202.958,122.589 L202.958,137.849 L187.698,137.849 L187.698,122.589 L202.958,122.589 Z M284.345,81.8954 L284.345,97.1554 L269.085,97.1554 L269.085,81.8954 L284.345,81.8954 Z M243.651,81.8954 L243.651,97.1554 L228.391,97.1554 L228.391,81.8954 L243.651,81.8954 Z M202.958,81.8954 L202.958,97.1554 L187.698,97.1554 L187.698,81.8954 L202.958,81.8954 Z M284.345,41.202 L284.345,56.462 L269.085,56.462 L269.085,41.202 L284.345,41.202 Z M243.651,41.202 L243.651,56.462 L228.391,56.462 L228.391,41.202 L243.651,41.202 Z M284.345,0.508789 L284.345,15.7688 L269.085,15.7688 L269.085,0.508789 L284.345,0.508789 Z'/%3E%3C/g%3E%3C/svg%3E")`;
const darkSvg = `url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='313' height='461' viewBox='0 0 313 461'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cpath fill='%2318191E' d='M294.009,184.137 C456.386,184.137 588.018,315.77 588.018,478.146 C588.018,640.523 456.386,772.156 294.009,772.156 C131.632,772.156 0,640.523 0,478.146 C0,315.77 131.632,184.137 294.009,184.137 Z M294.009,384.552 C242.318,384.552 200.415,426.456 200.415,478.146 C200.415,529.837 242.318,571.741 294.009,571.741 C345.7,571.741 387.604,529.837 387.604,478.146 C387.604,426.456 345.7,384.552 294.009,384.552 Z'/%3E%3Cpath fill='%2315161B' d='M202.958,365.731 L202.958,380.991 L187.698,380.991 L187.698,365.731 L202.958,365.731 Z M202.958,327.073 L202.958,342.333 L187.698,342.333 L187.698,327.073 L202.958,327.073 Z M243.651,325.038 L243.651,340.298 L228.391,340.298 L228.391,325.038 L243.651,325.038 Z M243.651,286.379 L243.651,301.639 L228.391,301.639 L228.391,286.379 L243.651,286.379 Z M202.958,285.362 L202.958,300.622 L187.698,300.622 L187.698,285.362 L202.958,285.362 Z M284.345,284.345 L284.345,299.605 L269.085,299.605 L269.085,284.345 L284.345,284.345 Z M284.345,245.686 L284.345,260.946 L269.085,260.946 L269.085,245.686 L284.345,245.686 Z M243.651,244.669 L243.651,259.929 L228.391,259.929 L228.391,244.669 L243.651,244.669 Z M202.958,243.651 L202.958,258.911 L187.698,258.911 L187.698,243.651 L202.958,243.651 Z M284.345,203.975 L284.345,219.235 L269.085,219.235 L269.085,203.975 L284.345,203.975 Z M202.958,203.975 L202.958,219.235 L187.698,219.235 L187.698,203.975 L202.958,203.975 Z M243.651,202.958 L243.651,218.218 L228.391,218.218 L228.391,202.958 L243.651,202.958 Z M243.651,163.282 L243.651,178.542 L228.391,178.542 L228.391,163.282 L243.651,163.282 Z M202.958,163.282 L202.958,178.542 L187.698,178.542 L187.698,163.282 L202.958,163.282 Z M284.345,162.265 L284.345,177.525 L269.085,177.525 L269.085,162.265 L284.345,162.265 Z M284.345,122.589 L284.345,137.849 L269.085,137.849 L269.085,122.589 L284.345,122.589 Z M243.651,122.589 L243.651,137.849 L228.391,137.849 L228.391,122.589 L243.651,122.589 Z M202.958,122.589 L202.958,137.849 L187.698,137.849 L187.698,122.589 L202.958,122.589 Z M284.345,81.8954 L284.345,97.1554 L269.085,97.1554 L269.085,81.8954 L284.345,81.8954 Z M243.651,81.8954 L243.651,97.1554 L228.391,97.1554 L228.391,81.8954 L243.651,81.8954 Z M202.958,81.8954 L202.958,97.1554 L187.698,97.1554 L187.698,81.8954 L202.958,81.8954 Z M284.345,41.202 L284.345,56.462 L269.085,56.462 L269.085,41.202 L284.345,41.202 Z M243.651,41.202 L243.651,56.462 L228.391,56.462 L228.391,41.202 L243.651,41.202 Z M284.345,0.508789 L284.345,15.7688 L269.085,15.7688 L269.085,0.508789 L284.345,0.508789 Z'/%3E%3C/g%3E%3C/svg%3E")`;
const newVisModalStyles = {
  base: euiThemeContext => (0, _react2.css)({
    maxWidth: modalWidth(euiThemeContext),
    maxHeight: modalHeight(euiThemeContext),
    background: euiThemeContext.euiTheme.colors.backgroundBasePlain,
    [(0, _eui.euiBreakpoint)(euiThemeContext, ['xs', 's'])]: {
      maxHeight: '100%'
    }
  }),
  aggbased: euiThemeContext => (0, _react2.css)({
    maxWidth: modalWidth(euiThemeContext),
    maxHeight: modalHeight(euiThemeContext),
    backgroundRepeat: 'no-repeat',
    backgroundPosition: 'calc(100% + 1px) calc(100% + 1px)',
    backgroundSize: '30%',
    backgroundImage: euiThemeContext.colorMode === _eui.COLOR_MODES_STANDARD.light ? lightSvg : darkSvg,
    [(0, _eui.euiBreakpoint)(euiThemeContext, ['xs', 's'])]: {
      maxHeight: '100%'
    }
  }),
  searchDialog: euiThemeContext => (0, _react2.css)({
    minWidth: modalWidth(euiThemeContext),
    minHeight: modalHeight(euiThemeContext)
  })
};
// TODO: redirect logic is specific to visualise & dashboard
// but it is likely should be decoupled. e.g. handled by the container instead
const basePath = `/create?`;
const baseUrl = `/app/visualize#${basePath}`;
class NewVisModal extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "trackUiMetric", void 0);
    (0, _defineProperty2.default)(this, "setTab", tab => {
      this.setState({
        tab
      });
    });
    (0, _defineProperty2.default)(this, "onCloseModal", () => {
      this.setState({
        showSearchVisModal: false
      });
      this.props.onClose();
    });
    (0, _defineProperty2.default)(this, "onVisTypeSelected", visType => {
      if ('visConfig' in visType && visType.requiresSearch && visType.options.showIndexSelection) {
        this.setState({
          showSearchVisModal: true,
          visType
        });
      } else {
        this.redirectToVis(visType);
      }
    });
    (0, _defineProperty2.default)(this, "onSearchSelected", (searchId, searchType) => {
      this.redirectToVis(this.state.visType, searchType, searchId);
    });
    this.state = {
      showSearchVisModal: Boolean(this.props.selectedVisType),
      isMainDialogShown: !this.props.showAggsSelection,
      visType: this.props.selectedVisType,
      tab: 'recommended'
    };
  }
  render() {
    if (!this.props.isOpen) {
      return null;
    }
    const WizardComponent = this.state.isMainDialogShown ? _group_selection.GroupSelection : _agg_based_selection.AggBasedSelection;
    const selectionModal = this.state.showSearchVisModal && this.state.visType ? /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      onClose: this.onCloseModal,
      "aria-labelledby": "vis-wizard-modal-title",
      css: newVisModalStyles.searchDialog,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_search_selection.SearchSelection, {
      contentClient: this.props.contentClient,
      uiSettings: this.props.uiSettings,
      onSearchSelected: this.onSearchSelected,
      visType: this.state.visType,
      goBack: () => this.setState({
        showSearchVisModal: false
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 11
      }
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      onClose: this.onCloseModal,
      "aria-labelledby": "vis-wizard-modal-title",
      css: this.state.isMainDialogShown ? newVisModalStyles.base : newVisModalStyles.aggbased,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(WizardComponent, {
      onVisTypeSelected: this.onVisTypeSelected,
      visTypesRegistry: this.props.visTypesRegistry,
      docLinks: this.props.docLinks,
      setTab: this.setTab,
      tab: this.state.tab,
      showMainDialog: shouldMainBeShown => {
        this.setState({
          isMainDialogShown: shouldMainBeShown
        });
        if (shouldMainBeShown) {
          this.setTab('legacy');
        }
      },
      openedAsRoot: this.props.showAggsSelection && !this.props.selectedVisType,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 11
      }
    }));
    return selectionModal;
  }
  redirectToVis(visType, searchType, searchId) {
    if (this.trackUiMetric) {
      this.trackUiMetric(_analytics.METRIC_TYPE.CLICK, `${visType.name}:create`);
    }
    let params;
    if ('alias' in visType) {
      if (visType.alias && 'path' in visType.alias) {
        params = visType.alias.path;
        this.props.onClose();
        this.navigate(visType.alias.app, visType.alias.path);
      }
      return;
    }
    params = [`type=${encodeURIComponent(visType.name)}`];
    if (searchType) {
      params.push(`${searchType === 'search' ? 'savedSearchId' : 'indexPattern'}=${searchId}`);
    }
    params = params.concat(this.props.editorParams);
    this.props.onClose();
    if (this.props.outsideVisualizeApp) {
      this.navigate('visualize', `#${basePath}${params.join('&')}`);
    } else {
      location.assign(this.props.addBasePath(`${baseUrl}${params.join('&')}`));
    }
  }
  navigate(appId, params) {
    if (this.props.stateTransfer && this.props.originatingApp) {
      this.props.stateTransfer.navigateToEditor(appId, {
        path: params,
        state: {
          originatingApp: this.props.originatingApp
        }
      });
    } else {
      this.props.application.navigateToApp(appId, {
        path: params
      });
    }
  }
}

// Needed for React.lazy
// eslint-disable-next-line import/no-default-export
exports.default = NewVisModal;
(0, _defineProperty2.default)(NewVisModal, "defaultProps", {
  editorParams: []
});
module.exports = exports.default;