"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggBasedSelection = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _memoize = require("../../legacy/memoize");
var _vis_groups_enum = require("../../vis_types/vis_groups_enum");
var _dialog_navigation = require("../dialog_navigation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/visualizations/public/wizard/agg_based_selection/agg_based_selection.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
class AggBasedSelection extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      query: ''
    });
    (0, _defineProperty2.default)(this, "getFilteredVisTypes", (0, _memoize.memoizeLast)(this.filteredVisTypes));
    (0, _defineProperty2.default)(this, "renderVisType", visType => {
      const isDisabled = this.state.query !== '' && !visType.highlighted;
      const onClick = () => this.props.onVisTypeSelected(visType.type);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: visType.type.name,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
        titleSize: "xs",
        title: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "visTypeTitle",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 136,
            columnNumber: 18
          }
        }, visType.type.title),
        onClick: onClick,
        "data-test-subj": `visType-${visType.type.name}`,
        "data-vis-stage": visType.type.stage,
        "aria-label": `visType-${visType.type.name}`,
        description: visType.type.description || '',
        layout: "horizontal",
        isDisabled: isDisabled,
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: visType.type.icon || 'empty',
          size: "l",
          color: "success",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 144,
            columnNumber: 17
          }
        }),
        className: "aggBasedDialog__card",
        hasBorder: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 9
        }
      }));
    });
    (0, _defineProperty2.default)(this, "onQueryChange", ev => {
      this.setState({
        query: ev.target.value
      });
    });
  }
  render() {
    const {
      query
    } = this.state;
    const visTypes = this.getFilteredVisTypes(this.props.visTypesRegistry, query);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
      id: "vis-wizard-modal-title",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visualizations.newAggVisWizard.title",
      defaultMessage: "New aggregation based visualization",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 9
      }
    }, this.props.openedAsRoot ? null : /*#__PURE__*/_react.default.createElement(_dialog_navigation.DialogNavigation, {
      goBack: () => this.props.showMainDialog(true),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
      placeholder: "Filter",
      value: query,
      onChange: this.onQueryChange,
      fullWidth: true,
      "data-test-subj": "filterVisType",
      "aria-label": _i18n.i18n.translate('visualizations.newVisWizard.filterVisTypeAriaLabel', {
        defaultMessage: 'Filter for a visualization type'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      "aria-live": "polite",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 13
      }
    }, query && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visualizations.newVisWizard.resultsFound",
      defaultMessage: "{resultCount, plural, one {type} other {types}} found",
      values: {
        resultCount: visTypes.filter(type => type.highlighted).length
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
      columns: 3,
      "data-test-subj": "visNewDialogTypes",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 11
      }
    }, visTypes.map(this.renderVisType))));
  }
  filteredVisTypes(visTypes, query) {
    const types = visTypes.getByGroup(_vis_groups_enum.VisGroups.AGGBASED).filter(type => {
      // Filter out hidden visualizations and visualizations that are only aggregations based
      return !type.disableCreate;
    });
    let entries;
    if (!query) {
      entries = types.map(type => ({
        type,
        highlighted: false
      }));
    } else {
      const q = query.toLowerCase();
      entries = types.map(type => {
        const matchesQuery = type.name.toLowerCase().includes(q) || type.title.toLowerCase().includes(q) || typeof type.description === 'string' && type.description.toLowerCase().includes(q);
        return {
          type,
          highlighted: matchesQuery
        };
      });
    }
    return (0, _lodash.orderBy)(entries, ['highlighted', 'type.title'], ['desc', 'asc']);
  }
}
exports.AggBasedSelection = AggBasedSelection;