"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VizChartWarning = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _split_chart_warning_helpers = require("../utils/split_chart_warning_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/visualizations/public/visualize_app/components/viz_chart_warning.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const SwitchToOldLibraryMessage = ({
  canEditAdvancedSettings,
  advancedSettingsLink,
  mode = 'old'
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, canEditAdvancedSettings && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.newChart.conditionalMessage.newLibrary",
    defaultMessage: "Switch to the {type} library in {link}",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: advancedSettingsLink,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 51,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visualizations.newChart.conditionalMessage.advancedSettingsLink",
        defaultMessage: "Advanced Settings.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 52,
          columnNumber: 17
        }
      })),
      type: mode === 'old' ? _i18n.i18n.translate('visualizations.newChart.libraryMode.old', {
        defaultMessage: 'old'
      }) : _i18n.i18n.translate('visualizations.newChart.libraryMode.new', {
        defaultMessage: 'new'
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }));
};
const ContactAdminMessage = ({
  canEditAdvancedSettings
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !canEditAdvancedSettings && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.legacyCharts.conditionalMessage.noPermissions",
    defaultMessage: "Contact your system administrator to switch to the old library.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }));
};
const GaugeWarningFormatMessage = props => {
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.newGaugeChart.notificationMessage",
    defaultMessage: "The new gauge charts library does not yet support split chart aggregation. {conditionalMessage}",
    values: {
      conditionalMessage: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(SwitchToOldLibraryMessage, (0, _extends2.default)({}, props, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(ContactAdminMessage, (0, _extends2.default)({}, props, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 13
        }
      })))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  });
};
const PieWarningFormatMessage = props => {
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.oldPieChart.notificationMessage",
    defaultMessage: "You are using the legacy charts library, which will be removed in a future version. {conditionalMessage}",
    values: {
      conditionalMessage: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(SwitchToOldLibraryMessage, (0, _extends2.default)({}, props, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(ContactAdminMessage, (0, _extends2.default)({}, props, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 13
        }
      })))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 5
    }
  });
};
const ControlsWarningFormatMessage = props => {
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.controls.notificationMessage",
    defaultMessage: "Input controls are deprecated and will be removed in a future release. Use the new Controls to filter and interact with your dashboard data. ",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 5
    }
  });
};
const warningMessages = {
  [_split_chart_warning_helpers.CHARTS_WITHOUT_SMALL_MULTIPLES.gauge]: GaugeWarningFormatMessage,
  [_split_chart_warning_helpers.CHARTS_TO_BE_DEPRECATED.pie]: PieWarningFormatMessage,
  [_split_chart_warning_helpers.CHARTS_TO_BE_DEPRECATED.controls]: ControlsWarningFormatMessage
};
const VizChartWarning = ({
  chartType,
  chartConfigToken,
  mode
}) => {
  const {
    services
  } = (0, _public.useKibana)();
  const canEditAdvancedSettings = services.application.capabilities.advancedSettings.save;
  const advancedSettingsLink = services.application.getUrlForApp('management', {
    path: `/kibana/settings?query=${chartConfigToken}`
  });
  const WarningMessage = warningMessages[chartType];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "vizChartWarning",
    title: /*#__PURE__*/_react.default.createElement(WarningMessage, {
      advancedSettingsLink: advancedSettingsLink,
      canEditAdvancedSettings: canEditAdvancedSettings,
      mode: mode,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 9
      }
    }),
    iconType: "warning",
    color: "warning",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 5
    }
  });
};
exports.VizChartWarning = VizChartWarning;