"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visTypeAliasRegistry = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * A slim visualization client used but the vis plugin to save basic attributes
 *
 * TODO cleanup the vis-type client code.
 * All viz pass this client require type overrides to adopt VisualizationClient
 */

let registry = [];
const discardOnRegister = [];
const visTypeAliasRegistry = exports.visTypeAliasRegistry = {
  get: () => [...registry],
  add: newVisTypeAlias => {
    if (registry.find(visTypeAlias => visTypeAlias.name === newVisTypeAlias.name)) {
      throw new Error(`${newVisTypeAlias.name} already registered`);
    }
    // if it exists on discardOnRegister array then we don't allow it to be registered
    const isToBeDiscarded = discardOnRegister.some(aliasName => aliasName === newVisTypeAlias.name);
    if (!isToBeDiscarded) {
      registry.push(newVisTypeAlias);
    }
  },
  remove: visTypeAliasName => {
    const isAliasPresent = registry.find(visTypeAlias => visTypeAlias.name === visTypeAliasName);
    // in case the alias has not registered yet we store it on an array, in order to not allow it to
    // be registered in case of a race condition
    if (!isAliasPresent) {
      discardOnRegister.push(visTypeAliasName);
    } else {
      registry = registry.filter(visTypeAlias => visTypeAlias.name !== visTypeAliasName);
    }
  }
};