"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visualizeStyle = exports.visualizeClassName = exports.visContainerStyle = exports.visContainerClassName = void 0;
var _css = require("@emotion/css");
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const visStyles = {
  visualize: `
    display: flex;
    flex: 1 1 100%;
    overflow: hidden;
  `,
  visContainer: `
    display: flex;
    flex: 1 1 auto;
    justify-content: center;
    align-items: center;
    text-align: center;
  `
};
const visualizeStyle = exports.visualizeStyle = (0, _react.css)(visStyles.visualize);
const visualizeClassName = exports.visualizeClassName = (0, _css.css)(visStyles.visualize);
const visContainerStyle = exports.visContainerStyle = (0, _react.css)(visStyles.visContainer);
const visContainerClassName = exports.visContainerClassName = (0, _css.css)(visStyles.visContainer);