"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkForDuplicateTitle = checkForDuplicateTitle;
var _constants = require("./constants");
var _find_visualization_by_title = require("./find_visualization_by_title");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Check for an existing VisSavedObject with the same title in ES
 * returns Promise<true> when it's no duplicate, or the modal displaying the warning
 * that's there's a duplicate is confirmed, else it returns a rejected Promise<ErrorMsg>
 */
async function checkForDuplicateTitle(savedObject, copyOnSave, isTitleDuplicateConfirmed, onTitleDuplicate) {
  // Don't check for duplicates if user has already confirmed save with duplicate title
  if (isTitleDuplicateConfirmed) {
    return true;
  }

  // Don't check if the user isn't updating the title, otherwise that would become very annoying to have
  // to confirm the save every time, except when copyOnSave is true, then we do want to check.
  if (savedObject.title === savedObject.lastSavedTitle && !copyOnSave) {
    return true;
  }
  const duplicate = await (0, _find_visualization_by_title.findVisualizationByTitle)(savedObject.title);
  if (!duplicate || duplicate.id === savedObject.id) {
    return true;
  }
  onTitleDuplicate();
  return Promise.reject(new Error(_constants.SAVE_DUPLICATE_REJECTED));
}